/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.builder.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.DateUtils;

@SdkInternalApi
public final class DateModule {
    public static final SimpleModule INSTANCE = new SimpleModule();

    private DateModule() {
    }

    public static Date fromJson(String jsonText) {
        return Date.from(DateUtils.parseIso8601Date((String)jsonText));
    }

    static {
        INSTANCE.addSerializer(Date.class, (JsonSerializer)new StdSerializer<Date>(Date.class){

            public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(DateUtils.formatIso8601Date((Instant)date.toInstant()));
            }
        });
        INSTANCE.addDeserializer(Date.class, (JsonDeserializer)new StdDeserializer<Date>(Date.class){

            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return DateModule.fromJson(jsonParser.getValueAsString());
            }
        });
    }
}

