/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.builder.conditions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.sfn.builder.conditions.BinaryCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.BinaryConditionBuilder;

@SdkPublicApi
public final class NumericEqualsCondition
implements BinaryCondition<String> {
    @JsonProperty(value="Variable")
    private final String variable;
    @JsonProperty(value="NumericEquals")
    private final NumericNode expectedValue;

    private NumericEqualsCondition(Builder builder) {
        this.variable = builder.variable;
        this.expectedValue = builder.expectedValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    @JsonIgnore
    public String getExpectedValue() {
        return this.expectedValue.asText();
    }

    public static final class Builder
    extends BinaryConditionBuilder {
        @JsonProperty(value="Variable")
        private String variable;
        @JsonProperty(value="NumericEquals")
        private NumericNode expectedValue;

        private Builder() {
        }

        @Override
        public Builder variable(String variable) {
            this.variable = variable;
            return this;
        }

        public Builder expectedValue(long expectedValue) {
            this.expectedValue = new LongNode(expectedValue);
            return this;
        }

        public Builder expectedValue(double expectedValue) {
            this.expectedValue = new DoubleNode(expectedValue);
            return this;
        }

        @Override
        Builder expectedValue(JsonNode expectedValue) {
            this.expectedValue = (NumericNode)expectedValue;
            return this;
        }

        @Override
        String type() {
            return "NumericEquals";
        }

        @Override
        public NumericEqualsCondition build() {
            return new NumericEqualsCondition(this);
        }
    }
}

