/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.builder.conditions;

import com.fasterxml.jackson.databind.JsonNode;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sfn.builder.conditions.AndCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.BinaryConditionBuilder;
import software.amazon.awssdk.services.sfn.builder.conditions.BooleanEqualsCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.Condition;
import software.amazon.awssdk.services.sfn.builder.conditions.NotCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.NumericEqualsCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.NumericGreaterThanCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.NumericGreaterThanOrEqualCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.NumericLessThanCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.NumericLessThanOrEqualCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.OrCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.StringEqualsCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.StringGreaterThanCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.StringGreaterThanOrEqualCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.StringLessThanCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.StringLessThanOrEqualCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.TimestampEqualsCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.TimestampGreaterThanCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.TimestampGreaterThanOrEqualCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.TimestampLessThanCondition;
import software.amazon.awssdk.services.sfn.builder.conditions.TimestampLessThanOrEqualCondition;

@SdkInternalApi
public class ConditionDeserializer {
    public Condition.Builder deserializeCondition(JsonNode node) {
        if (node.has("Variable")) {
            if (node.has("StringEquals")) {
                return this.deserializeBinaryCondition(StringEqualsCondition.builder(), node);
            }
            if (node.has("StringGreaterThan")) {
                return this.deserializeBinaryCondition(StringGreaterThanCondition.builder(), node);
            }
            if (node.has("StringGreaterThanEquals")) {
                return this.deserializeBinaryCondition(StringGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("StringLessThan")) {
                return this.deserializeBinaryCondition(StringLessThanCondition.builder(), node);
            }
            if (node.has("StringLessThanEquals")) {
                return this.deserializeBinaryCondition(StringLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("TimestampEquals")) {
                return this.deserializeBinaryCondition(TimestampEqualsCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThan")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThanEquals")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("TimestampLessThan")) {
                return this.deserializeBinaryCondition(TimestampLessThanCondition.builder(), node);
            }
            if (node.has("TimestampLessThanEquals")) {
                return this.deserializeBinaryCondition(TimestampLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("NumericEquals")) {
                return this.deserializeBinaryCondition(NumericEqualsCondition.builder(), node);
            }
            if (node.has("NumericGreaterThan")) {
                return this.deserializeBinaryCondition(NumericGreaterThanCondition.builder(), node);
            }
            if (node.has("NumericGreaterThanEquals")) {
                return this.deserializeBinaryCondition(NumericGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("NumericLessThan")) {
                return this.deserializeBinaryCondition(NumericLessThanCondition.builder(), node);
            }
            if (node.has("NumericLessThanEquals")) {
                return this.deserializeBinaryCondition(NumericLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("BooleanEquals")) {
                return this.deserializeBinaryCondition(BooleanEqualsCondition.builder(), node);
            }
        } else {
            if (node.has("And")) {
                AndCondition.Builder builder = AndCondition.builder();
                for (JsonNode inner : node.get("And")) {
                    builder.condition(this.deserializeCondition(inner));
                }
                return builder;
            }
            if (node.has("Or")) {
                OrCondition.Builder builder = OrCondition.builder();
                for (JsonNode inner : node.get("Or")) {
                    builder.condition(this.deserializeCondition(inner));
                }
                return builder;
            }
            if (node.has("Not")) {
                return NotCondition.builder().condition(this.deserializeCondition(node.get("Not")));
            }
        }
        throw SdkClientException.builder().message("Condition must be provided").build();
    }

    private Condition.Builder deserializeBinaryCondition(BinaryConditionBuilder builder, JsonNode node) {
        return builder.variable(node.get("Variable").asText()).expectedValue(node.get(builder.type()));
    }
}

