/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains basic information about a tenant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TenantInfo implements SdkPojo, Serializable, ToCopyableBuilder<TenantInfo.Builder, TenantInfo> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantName").getter(getter(TenantInfo::tenantName)).setter(setter(Builder::tenantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(TenantInfo::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<String> TENANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantArn").getter(getter(TenantInfo::tenantArn)).setter(setter(Builder::tenantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(TenantInfo::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD,
            TENANT_ID_FIELD, TENANT_ARN_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantName;

    private final String tenantId;

    private final String tenantArn;

    private final Instant createdTimestamp;

    private TenantInfo(BuilderImpl builder) {
        this.tenantName = builder.tenantName;
        this.tenantId = builder.tenantId;
        this.tenantArn = builder.tenantArn;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The name of the tenant.
     * </p>
     * 
     * @return The name of the tenant.
     */
    public final String tenantName() {
        return tenantName;
    }

    /**
     * <p>
     * A unique identifier for the tenant.
     * </p>
     * 
     * @return A unique identifier for the tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tenant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tenant.
     */
    public final String tenantArn() {
        return tenantArn;
    }

    /**
     * <p>
     * The date and time when the tenant was created.
     * </p>
     * 
     * @return The date and time when the tenant was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(tenantArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TenantInfo)) {
            return false;
        }
        TenantInfo other = (TenantInfo) obj;
        return Objects.equals(tenantName(), other.tenantName()) && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(tenantArn(), other.tenantArn()) && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TenantInfo").add("TenantName", tenantName()).add("TenantId", tenantId())
                .add("TenantArn", tenantArn()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantName":
            return Optional.ofNullable(clazz.cast(tenantName()));
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "TenantArn":
            return Optional.ofNullable(clazz.cast(tenantArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("TenantArn", TENANT_ARN_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TenantInfo, T> g) {
        return obj -> g.apply((TenantInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TenantInfo> {
        /**
         * <p>
         * The name of the tenant.
         * </p>
         * 
         * @param tenantName
         *        The name of the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantName(String tenantName);

        /**
         * <p>
         * A unique identifier for the tenant.
         * </p>
         * 
         * @param tenantId
         *        A unique identifier for the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tenant.
         * </p>
         * 
         * @param tenantArn
         *        The Amazon Resource Name (ARN) of the tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantArn(String tenantArn);

        /**
         * <p>
         * The date and time when the tenant was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The date and time when the tenant was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String tenantName;

        private String tenantId;

        private String tenantArn;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(TenantInfo model) {
            tenantName(model.tenantName);
            tenantId(model.tenantId);
            tenantArn(model.tenantArn);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getTenantName() {
            return tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTenantArn() {
            return tenantArn;
        }

        public final void setTenantArn(String tenantArn) {
            this.tenantArn = tenantArn;
        }

        @Override
        public final Builder tenantArn(String tenantArn) {
            this.tenantArn = tenantArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public TenantInfo build() {
            return new TenantInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
