/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about your account details review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewDetails implements SdkPojo, Serializable, ToCopyableBuilder<ReviewDetails.Builder, ReviewDetails> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReviewDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CaseId")
            .getter(getter(ReviewDetails::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CASE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String caseId;

    private ReviewDetails(BuilderImpl builder) {
        this.status = builder.status;
        this.caseId = builder.caseId;
    }

    /**
     * <p>
     * The status of the latest review of your account. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit your appeal
     * again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the latest review of your account. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit your
     *         appeal again.
     *         </p>
     *         </li>
     * @see ReviewStatus
     */
    public final ReviewStatus status() {
        return ReviewStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the latest review of your account. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit your appeal
     * again.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the latest review of your account. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit your
     *         appeal again.
     *         </p>
     *         </li>
     * @see ReviewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The associated support center case ID (if any).
     * </p>
     * 
     * @return The associated support center case ID (if any).
     */
    public final String caseId() {
        return caseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewDetails)) {
            return false;
        }
        ReviewDetails other = (ReviewDetails) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(caseId(), other.caseId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReviewDetails").add("Status", statusAsString()).add("CaseId", caseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CaseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("CaseId", CASE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReviewDetails, T> g) {
        return obj -> g.apply((ReviewDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewDetails> {
        /**
         * <p>
         * The status of the latest review of your account. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit your
         * appeal again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the latest review of your account. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit
         *        your appeal again.
         *        </p>
         *        </li>
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the latest review of your account. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit your
         * appeal again.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the latest review of your account. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – An internal error occurred and we didn't receive your appeal. You can submit
         *        your appeal again.
         *        </p>
         *        </li>
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder status(ReviewStatus status);

        /**
         * <p>
         * The associated support center case ID (if any).
         * </p>
         * 
         * @param caseId
         *        The associated support center case ID (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String caseId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewDetails model) {
            status(model.status);
            caseId(model.caseId);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        @Override
        public ReviewDetails build() {
            return new ReviewDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
