/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing Message Insights filters.
 * </p>
 * <p>
 * If you specify multiple filters, the filters are joined by AND.
 * </p>
 * <p>
 * If you specify multiple values for a filter, the values are joined by OR. Filter values are case-sensitive.
 * </p>
 * <p>
 * <code>FromEmailAddress</code>, <code>Destination</code>, and <code>Subject</code> filters support partial match. A
 * partial match is performed by using the <code>*</code> wildcard character placed at the beginning (suffix match), the
 * end (prefix match) or both ends of the string (contains match). In order to match the literal characters
 * <code>*</code> or <code>\</code>, they must be escaped using the <code>\</code> character. If no wildcard character
 * is present, an exact match is performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageInsightsFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageInsightsFilters.Builder, MessageInsightsFilters> {
    private static final SdkField<List<String>> FROM_EMAIL_ADDRESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FromEmailAddress")
            .getter(getter(MessageInsightsFilters::fromEmailAddress))
            .setter(setter(Builder::fromEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESTINATION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Destination")
            .getter(getter(MessageInsightsFilters::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBJECT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subject")
            .getter(getter(MessageInsightsFilters::subject))
            .setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ISP_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Isp")
            .getter(getter(MessageInsightsFilters::isp))
            .setter(setter(Builder::isp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Isp").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LAST_DELIVERY_EVENT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LastDeliveryEvent")
            .getter(getter(MessageInsightsFilters::lastDeliveryEventAsStrings))
            .setter(setter(Builder::lastDeliveryEventWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeliveryEvent").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LAST_ENGAGEMENT_EVENT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LastEngagementEvent")
            .getter(getter(MessageInsightsFilters::lastEngagementEventAsStrings))
            .setter(setter(Builder::lastEngagementEventWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEngagementEvent").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_EMAIL_ADDRESS_FIELD,
            DESTINATION_FIELD, SUBJECT_FIELD, ISP_FIELD, LAST_DELIVERY_EVENT_FIELD, LAST_ENGAGEMENT_EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> fromEmailAddress;

    private final List<String> destination;

    private final List<String> subject;

    private final List<String> isp;

    private final List<String> lastDeliveryEvent;

    private final List<String> lastEngagementEvent;

    private MessageInsightsFilters(BuilderImpl builder) {
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destination = builder.destination;
        this.subject = builder.subject;
        this.isp = builder.isp;
        this.lastDeliveryEvent = builder.lastDeliveryEvent;
        this.lastEngagementEvent = builder.lastEngagementEvent;
    }

    /**
     * For responses, this returns true if the service returned a value for the FromEmailAddress property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFromEmailAddress() {
        return fromEmailAddress != null && !(fromEmailAddress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The from address used to send the message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFromEmailAddress} method.
     * </p>
     * 
     * @return The from address used to send the message.
     */
    public final List<String> fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destination property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestination() {
        return destination != null && !(destination instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recipient's email address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestination} method.
     * </p>
     * 
     * @return The recipient's email address.
     */
    public final List<String> destination() {
        return destination;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subject property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubject() {
        return subject != null && !(subject instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subject line of the message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubject} method.
     * </p>
     * 
     * @return The subject line of the message.
     */
    public final List<String> subject() {
        return subject;
    }

    /**
     * For responses, this returns true if the service returned a value for the Isp property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIsp() {
        return isp != null && !(isp instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIsp} method.
     * </p>
     * 
     * @return The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
     */
    public final List<String> isp() {
        return isp;
    }

    /**
     * <p>
     * The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
     * <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastDeliveryEvent} method.
     * </p>
     * 
     * @return The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
     *         <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
     */
    public final List<DeliveryEventType> lastDeliveryEvent() {
        return LastDeliveryEventListCopier.copyStringToEnum(lastDeliveryEvent);
    }

    /**
     * For responses, this returns true if the service returned a value for the LastDeliveryEvent property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastDeliveryEvent() {
        return lastDeliveryEvent != null && !(lastDeliveryEvent instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
     * <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastDeliveryEvent} method.
     * </p>
     * 
     * @return The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
     *         <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
     */
    public final List<String> lastDeliveryEventAsStrings() {
        return lastDeliveryEvent;
    }

    /**
     * <p>
     * The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
     * <code>CLICK</code>.
     * </p>
     * <p>
     * Engagement events are only available if <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastEngagementEvent} method.
     * </p>
     * 
     * @return The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
     *         <code>CLICK</code>. </p>
     *         <p>
     *         Engagement events are only available if <a
     *         href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
     */
    public final List<EngagementEventType> lastEngagementEvent() {
        return LastEngagementEventListCopier.copyStringToEnum(lastEngagementEvent);
    }

    /**
     * For responses, this returns true if the service returned a value for the LastEngagementEvent property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastEngagementEvent() {
        return lastEngagementEvent != null && !(lastEngagementEvent instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
     * <code>CLICK</code>.
     * </p>
     * <p>
     * Engagement events are only available if <a
     * href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastEngagementEvent} method.
     * </p>
     * 
     * @return The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
     *         <code>CLICK</code>. </p>
     *         <p>
     *         Engagement events are only available if <a
     *         href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
     */
    public final List<String> lastEngagementEventAsStrings() {
        return lastEngagementEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFromEmailAddress() ? fromEmailAddress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestination() ? destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubject() ? subject() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIsp() ? isp() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastDeliveryEvent() ? lastDeliveryEventAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastEngagementEvent() ? lastEngagementEventAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageInsightsFilters)) {
            return false;
        }
        MessageInsightsFilters other = (MessageInsightsFilters) obj;
        return hasFromEmailAddress() == other.hasFromEmailAddress()
                && Objects.equals(fromEmailAddress(), other.fromEmailAddress()) && hasDestination() == other.hasDestination()
                && Objects.equals(destination(), other.destination()) && hasSubject() == other.hasSubject()
                && Objects.equals(subject(), other.subject()) && hasIsp() == other.hasIsp() && Objects.equals(isp(), other.isp())
                && hasLastDeliveryEvent() == other.hasLastDeliveryEvent()
                && Objects.equals(lastDeliveryEventAsStrings(), other.lastDeliveryEventAsStrings())
                && hasLastEngagementEvent() == other.hasLastEngagementEvent()
                && Objects.equals(lastEngagementEventAsStrings(), other.lastEngagementEventAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageInsightsFilters")
                .add("FromEmailAddress", fromEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Destination", destination() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Subject", subject() == null ? null : "*** Sensitive Data Redacted ***").add("Isp", hasIsp() ? isp() : null)
                .add("LastDeliveryEvent", hasLastDeliveryEvent() ? lastDeliveryEventAsStrings() : null)
                .add("LastEngagementEvent", hasLastEngagementEvent() ? lastEngagementEventAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Isp":
            return Optional.ofNullable(clazz.cast(isp()));
        case "LastDeliveryEvent":
            return Optional.ofNullable(clazz.cast(lastDeliveryEventAsStrings()));
        case "LastEngagementEvent":
            return Optional.ofNullable(clazz.cast(lastEngagementEventAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Isp", ISP_FIELD);
        map.put("LastDeliveryEvent", LAST_DELIVERY_EVENT_FIELD);
        map.put("LastEngagementEvent", LAST_ENGAGEMENT_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageInsightsFilters, T> g) {
        return obj -> g.apply((MessageInsightsFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageInsightsFilters> {
        /**
         * <p>
         * The from address used to send the message.
         * </p>
         * 
         * @param fromEmailAddress
         *        The from address used to send the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(Collection<String> fromEmailAddress);

        /**
         * <p>
         * The from address used to send the message.
         * </p>
         * 
         * @param fromEmailAddress
         *        The from address used to send the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(String... fromEmailAddress);

        /**
         * <p>
         * The recipient's email address.
         * </p>
         * 
         * @param destination
         *        The recipient's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Collection<String> destination);

        /**
         * <p>
         * The recipient's email address.
         * </p>
         * 
         * @param destination
         *        The recipient's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String... destination);

        /**
         * <p>
         * The subject line of the message.
         * </p>
         * 
         * @param subject
         *        The subject line of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(Collection<String> subject);

        /**
         * <p>
         * The subject line of the message.
         * </p>
         * 
         * @param subject
         *        The subject line of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String... subject);

        /**
         * <p>
         * The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
         * </p>
         * 
         * @param isp
         *        The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isp(Collection<String> isp);

        /**
         * <p>
         * The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
         * </p>
         * 
         * @param isp
         *        The recipient's ISP (e.g., <code>Gmail</code>, <code>Yahoo</code>, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isp(String... isp);

        /**
         * <p>
         * The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
         * <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * </p>
         * 
         * @param lastDeliveryEvent
         *        The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code>
         *        &lt; <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeliveryEventWithStrings(Collection<String> lastDeliveryEvent);

        /**
         * <p>
         * The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
         * <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * </p>
         * 
         * @param lastDeliveryEvent
         *        The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code>
         *        &lt; <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeliveryEventWithStrings(String... lastDeliveryEvent);

        /**
         * <p>
         * The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
         * <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * </p>
         * 
         * @param lastDeliveryEvent
         *        The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code>
         *        &lt; <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeliveryEvent(Collection<DeliveryEventType> lastDeliveryEvent);

        /**
         * <p>
         * The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code> &lt;
         * <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * </p>
         * 
         * @param lastDeliveryEvent
         *        The last delivery-related event for the email, where the ordering is as follows: <code>SEND</code>
         *        &lt; <code>BOUNCE</code> &lt; <code>DELIVERY</code> &lt; <code>COMPLAINT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeliveryEvent(DeliveryEventType... lastDeliveryEvent);

        /**
         * <p>
         * The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
         * <code>CLICK</code>.
         * </p>
         * <p>
         * Engagement events are only available if <a
         * href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * </p>
         * 
         * @param lastEngagementEvent
         *        The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code>
         *        &lt; <code>CLICK</code>. </p>
         *        <p>
         *        Engagement events are only available if <a
         *        href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEngagementEventWithStrings(Collection<String> lastEngagementEvent);

        /**
         * <p>
         * The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
         * <code>CLICK</code>.
         * </p>
         * <p>
         * Engagement events are only available if <a
         * href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * </p>
         * 
         * @param lastEngagementEvent
         *        The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code>
         *        &lt; <code>CLICK</code>. </p>
         *        <p>
         *        Engagement events are only available if <a
         *        href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEngagementEventWithStrings(String... lastEngagementEvent);

        /**
         * <p>
         * The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
         * <code>CLICK</code>.
         * </p>
         * <p>
         * Engagement events are only available if <a
         * href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * </p>
         * 
         * @param lastEngagementEvent
         *        The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code>
         *        &lt; <code>CLICK</code>. </p>
         *        <p>
         *        Engagement events are only available if <a
         *        href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEngagementEvent(Collection<EngagementEventType> lastEngagementEvent);

        /**
         * <p>
         * The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code> &lt;
         * <code>CLICK</code>.
         * </p>
         * <p>
         * Engagement events are only available if <a
         * href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * </p>
         * 
         * @param lastEngagementEvent
         *        The last engagement-related event for the email, where the ordering is as follows: <code>OPEN</code>
         *        &lt; <code>CLICK</code>. </p>
         *        <p>
         *        Engagement events are only available if <a
         *        href="https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html">Engagement tracking</a> is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEngagementEvent(EngagementEventType... lastEngagementEvent);
    }

    static final class BuilderImpl implements Builder {
        private List<String> fromEmailAddress = DefaultSdkAutoConstructList.getInstance();

        private List<String> destination = DefaultSdkAutoConstructList.getInstance();

        private List<String> subject = DefaultSdkAutoConstructList.getInstance();

        private List<String> isp = DefaultSdkAutoConstructList.getInstance();

        private List<String> lastDeliveryEvent = DefaultSdkAutoConstructList.getInstance();

        private List<String> lastEngagementEvent = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageInsightsFilters model) {
            fromEmailAddress(model.fromEmailAddress);
            destination(model.destination);
            subject(model.subject);
            isp(model.isp);
            lastDeliveryEventWithStrings(model.lastDeliveryEvent);
            lastEngagementEventWithStrings(model.lastEngagementEvent);
        }

        public final Collection<String> getFromEmailAddress() {
            if (fromEmailAddress instanceof SdkAutoConstructList) {
                return null;
            }
            return fromEmailAddress;
        }

        public final void setFromEmailAddress(Collection<String> fromEmailAddress) {
            this.fromEmailAddress = EmailAddressFilterListCopier.copy(fromEmailAddress);
        }

        @Override
        public final Builder fromEmailAddress(Collection<String> fromEmailAddress) {
            this.fromEmailAddress = EmailAddressFilterListCopier.copy(fromEmailAddress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromEmailAddress(String... fromEmailAddress) {
            fromEmailAddress(Arrays.asList(fromEmailAddress));
            return this;
        }

        public final Collection<String> getDestination() {
            if (destination instanceof SdkAutoConstructList) {
                return null;
            }
            return destination;
        }

        public final void setDestination(Collection<String> destination) {
            this.destination = EmailAddressFilterListCopier.copy(destination);
        }

        @Override
        public final Builder destination(Collection<String> destination) {
            this.destination = EmailAddressFilterListCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(String... destination) {
            destination(Arrays.asList(destination));
            return this;
        }

        public final Collection<String> getSubject() {
            if (subject instanceof SdkAutoConstructList) {
                return null;
            }
            return subject;
        }

        public final void setSubject(Collection<String> subject) {
            this.subject = EmailSubjectFilterListCopier.copy(subject);
        }

        @Override
        public final Builder subject(Collection<String> subject) {
            this.subject = EmailSubjectFilterListCopier.copy(subject);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subject(String... subject) {
            subject(Arrays.asList(subject));
            return this;
        }

        public final Collection<String> getIsp() {
            if (isp instanceof SdkAutoConstructList) {
                return null;
            }
            return isp;
        }

        public final void setIsp(Collection<String> isp) {
            this.isp = IspFilterListCopier.copy(isp);
        }

        @Override
        public final Builder isp(Collection<String> isp) {
            this.isp = IspFilterListCopier.copy(isp);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isp(String... isp) {
            isp(Arrays.asList(isp));
            return this;
        }

        public final Collection<String> getLastDeliveryEvent() {
            if (lastDeliveryEvent instanceof SdkAutoConstructList) {
                return null;
            }
            return lastDeliveryEvent;
        }

        public final void setLastDeliveryEvent(Collection<String> lastDeliveryEvent) {
            this.lastDeliveryEvent = LastDeliveryEventListCopier.copy(lastDeliveryEvent);
        }

        @Override
        public final Builder lastDeliveryEventWithStrings(Collection<String> lastDeliveryEvent) {
            this.lastDeliveryEvent = LastDeliveryEventListCopier.copy(lastDeliveryEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastDeliveryEventWithStrings(String... lastDeliveryEvent) {
            lastDeliveryEventWithStrings(Arrays.asList(lastDeliveryEvent));
            return this;
        }

        @Override
        public final Builder lastDeliveryEvent(Collection<DeliveryEventType> lastDeliveryEvent) {
            this.lastDeliveryEvent = LastDeliveryEventListCopier.copyEnumToString(lastDeliveryEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastDeliveryEvent(DeliveryEventType... lastDeliveryEvent) {
            lastDeliveryEvent(Arrays.asList(lastDeliveryEvent));
            return this;
        }

        public final Collection<String> getLastEngagementEvent() {
            if (lastEngagementEvent instanceof SdkAutoConstructList) {
                return null;
            }
            return lastEngagementEvent;
        }

        public final void setLastEngagementEvent(Collection<String> lastEngagementEvent) {
            this.lastEngagementEvent = LastEngagementEventListCopier.copy(lastEngagementEvent);
        }

        @Override
        public final Builder lastEngagementEventWithStrings(Collection<String> lastEngagementEvent) {
            this.lastEngagementEvent = LastEngagementEventListCopier.copy(lastEngagementEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastEngagementEventWithStrings(String... lastEngagementEvent) {
            lastEngagementEventWithStrings(Arrays.asList(lastEngagementEvent));
            return this;
        }

        @Override
        public final Builder lastEngagementEvent(Collection<EngagementEventType> lastEngagementEvent) {
            this.lastEngagementEvent = LastEngagementEventListCopier.copyEnumToString(lastEngagementEvent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastEngagementEvent(EngagementEventType... lastEngagementEvent) {
            lastEngagementEvent(Arrays.asList(lastEngagementEvent));
            return this;
        }

        @Override
        public MessageInsightsFilters build() {
            return new MessageInsightsFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
