/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about tenants associated with a specific resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceTenantsResponse extends SesV2Response implements
        ToCopyableBuilder<ListResourceTenantsResponse.Builder, ListResourceTenantsResponse> {
    private static final SdkField<List<ResourceTenantMetadata>> RESOURCE_TENANTS_FIELD = SdkField
            .<List<ResourceTenantMetadata>> builder(MarshallingType.LIST)
            .memberName("ResourceTenants")
            .getter(getter(ListResourceTenantsResponse::resourceTenants))
            .setter(setter(Builder::resourceTenants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTenants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTenantMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTenantMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceTenantsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TENANTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResourceTenantMetadata> resourceTenants;

    private final String nextToken;

    private ListResourceTenantsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTenants = builder.resourceTenants;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTenants property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTenants() {
        return resourceTenants != null && !(resourceTenants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains information about each tenant associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTenants} method.
     * </p>
     * 
     * @return An array that contains information about each tenant associated with the resource.
     */
    public final List<ResourceTenantMetadata> resourceTenants() {
        return resourceTenants;
    }

    /**
     * <p>
     * A token that indicates that there are additional tenants to list. To view additional tenants, issue another
     * request to <code>ListResourceTenants</code>, and pass this token in the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return A token that indicates that there are additional tenants to list. To view additional tenants, issue
     *         another request to <code>ListResourceTenants</code>, and pass this token in the <code>NextToken</code>
     *         parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTenants() ? resourceTenants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTenantsResponse)) {
            return false;
        }
        ListResourceTenantsResponse other = (ListResourceTenantsResponse) obj;
        return hasResourceTenants() == other.hasResourceTenants() && Objects.equals(resourceTenants(), other.resourceTenants())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceTenantsResponse")
                .add("ResourceTenants", hasResourceTenants() ? resourceTenants() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTenants":
            return Optional.ofNullable(clazz.cast(resourceTenants()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceTenants", RESOURCE_TENANTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTenantsResponse, T> g) {
        return obj -> g.apply((ListResourceTenantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListResourceTenantsResponse> {
        /**
         * <p>
         * An array that contains information about each tenant associated with the resource.
         * </p>
         * 
         * @param resourceTenants
         *        An array that contains information about each tenant associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTenants(Collection<ResourceTenantMetadata> resourceTenants);

        /**
         * <p>
         * An array that contains information about each tenant associated with the resource.
         * </p>
         * 
         * @param resourceTenants
         *        An array that contains information about each tenant associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTenants(ResourceTenantMetadata... resourceTenants);

        /**
         * <p>
         * An array that contains information about each tenant associated with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadata.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceTenants(List<ResourceTenantMetadata>)}.
         * 
         * @param resourceTenants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.ResourceTenantMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTenants(java.util.Collection<ResourceTenantMetadata>)
         */
        Builder resourceTenants(Consumer<ResourceTenantMetadata.Builder>... resourceTenants);

        /**
         * <p>
         * A token that indicates that there are additional tenants to list. To view additional tenants, issue another
         * request to <code>ListResourceTenants</code>, and pass this token in the <code>NextToken</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there are additional tenants to list. To view additional tenants, issue
         *        another request to <code>ListResourceTenants</code>, and pass this token in the <code>NextToken</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<ResourceTenantMetadata> resourceTenants = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTenantsResponse model) {
            super(model);
            resourceTenants(model.resourceTenants);
            nextToken(model.nextToken);
        }

        public final List<ResourceTenantMetadata.Builder> getResourceTenants() {
            List<ResourceTenantMetadata.Builder> result = ResourceTenantMetadataListCopier.copyToBuilder(this.resourceTenants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTenants(Collection<ResourceTenantMetadata.BuilderImpl> resourceTenants) {
            this.resourceTenants = ResourceTenantMetadataListCopier.copyFromBuilder(resourceTenants);
        }

        @Override
        public final Builder resourceTenants(Collection<ResourceTenantMetadata> resourceTenants) {
            this.resourceTenants = ResourceTenantMetadataListCopier.copy(resourceTenants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTenants(ResourceTenantMetadata... resourceTenants) {
            resourceTenants(Arrays.asList(resourceTenants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTenants(Consumer<ResourceTenantMetadata.Builder>... resourceTenants) {
            resourceTenants(Stream.of(resourceTenants).map(c -> ResourceTenantMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceTenantsResponse build() {
            return new ListResourceTenantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
