/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results of the predictive inbox placement test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeliverabilityTestReportResponse extends SesV2Response implements
        ToCopyableBuilder<GetDeliverabilityTestReportResponse.Builder, GetDeliverabilityTestReportResponse> {
    private static final SdkField<DeliverabilityTestReport> DELIVERABILITY_TEST_REPORT_FIELD = SdkField
            .<DeliverabilityTestReport> builder(MarshallingType.SDK_POJO).memberName("DeliverabilityTestReport")
            .getter(getter(GetDeliverabilityTestReportResponse::deliverabilityTestReport))
            .setter(setter(Builder::deliverabilityTestReport)).constructor(DeliverabilityTestReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverabilityTestReport").build())
            .build();

    private static final SdkField<PlacementStatistics> OVERALL_PLACEMENT_FIELD = SdkField
            .<PlacementStatistics> builder(MarshallingType.SDK_POJO).memberName("OverallPlacement")
            .getter(getter(GetDeliverabilityTestReportResponse::overallPlacement)).setter(setter(Builder::overallPlacement))
            .constructor(PlacementStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallPlacement").build()).build();

    private static final SdkField<List<IspPlacement>> ISP_PLACEMENTS_FIELD = SdkField
            .<List<IspPlacement>> builder(MarshallingType.LIST)
            .memberName("IspPlacements")
            .getter(getter(GetDeliverabilityTestReportResponse::ispPlacements))
            .setter(setter(Builder::ispPlacements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IspPlacements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IspPlacement> builder(MarshallingType.SDK_POJO)
                                            .constructor(IspPlacement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(GetDeliverabilityTestReportResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GetDeliverabilityTestReportResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELIVERABILITY_TEST_REPORT_FIELD, OVERALL_PLACEMENT_FIELD, ISP_PLACEMENTS_FIELD, MESSAGE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DeliverabilityTestReport deliverabilityTestReport;

    private final PlacementStatistics overallPlacement;

    private final List<IspPlacement> ispPlacements;

    private final String message;

    private final List<Tag> tags;

    private GetDeliverabilityTestReportResponse(BuilderImpl builder) {
        super(builder);
        this.deliverabilityTestReport = builder.deliverabilityTestReport;
        this.overallPlacement = builder.overallPlacement;
        this.ispPlacements = builder.ispPlacements;
        this.message = builder.message;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * An object that contains the results of the predictive inbox placement test.
     * </p>
     * 
     * @return An object that contains the results of the predictive inbox placement test.
     */
    public final DeliverabilityTestReport deliverabilityTestReport() {
        return deliverabilityTestReport;
    }

    /**
     * <p>
     * An object that specifies how many test messages that were sent during the predictive inbox placement test were
     * delivered to recipients' inboxes, how many were sent to recipients' spam folders, and how many weren't delivered.
     * </p>
     * 
     * @return An object that specifies how many test messages that were sent during the predictive inbox placement test
     *         were delivered to recipients' inboxes, how many were sent to recipients' spam folders, and how many
     *         weren't delivered.
     */
    public final PlacementStatistics overallPlacement() {
        return overallPlacement;
    }

    /**
     * For responses, this returns true if the service returned a value for the IspPlacements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIspPlacements() {
        return ispPlacements != null && !(ispPlacements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that describes how the test email was handled by several email providers, including Gmail, Hotmail,
     * Yahoo, AOL, and others.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIspPlacements} method.
     * </p>
     * 
     * @return An object that describes how the test email was handled by several email providers, including Gmail,
     *         Hotmail, Yahoo, AOL, and others.
     */
    public final List<IspPlacement> ispPlacements() {
        return ispPlacements;
    }

    /**
     * <p>
     * An object that contains the message that you sent when you performed this predictive inbox placement test.
     * </p>
     * 
     * @return An object that contains the message that you sent when you performed this predictive inbox placement
     *         test.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that define the tags (keys and values) that are associated with the predictive inbox
     * placement test.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of objects that define the tags (keys and values) that are associated with the predictive inbox
     *         placement test.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliverabilityTestReport());
        hashCode = 31 * hashCode + Objects.hashCode(overallPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(hasIspPlacements() ? ispPlacements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeliverabilityTestReportResponse)) {
            return false;
        }
        GetDeliverabilityTestReportResponse other = (GetDeliverabilityTestReportResponse) obj;
        return Objects.equals(deliverabilityTestReport(), other.deliverabilityTestReport())
                && Objects.equals(overallPlacement(), other.overallPlacement()) && hasIspPlacements() == other.hasIspPlacements()
                && Objects.equals(ispPlacements(), other.ispPlacements()) && Objects.equals(message(), other.message())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeliverabilityTestReportResponse")
                .add("DeliverabilityTestReport", deliverabilityTestReport()).add("OverallPlacement", overallPlacement())
                .add("IspPlacements", hasIspPlacements() ? ispPlacements() : null).add("Message", message())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliverabilityTestReport":
            return Optional.ofNullable(clazz.cast(deliverabilityTestReport()));
        case "OverallPlacement":
            return Optional.ofNullable(clazz.cast(overallPlacement()));
        case "IspPlacements":
            return Optional.ofNullable(clazz.cast(ispPlacements()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliverabilityTestReport", DELIVERABILITY_TEST_REPORT_FIELD);
        map.put("OverallPlacement", OVERALL_PLACEMENT_FIELD);
        map.put("IspPlacements", ISP_PLACEMENTS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeliverabilityTestReportResponse, T> g) {
        return obj -> g.apply((GetDeliverabilityTestReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeliverabilityTestReportResponse> {
        /**
         * <p>
         * An object that contains the results of the predictive inbox placement test.
         * </p>
         * 
         * @param deliverabilityTestReport
         *        An object that contains the results of the predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverabilityTestReport(DeliverabilityTestReport deliverabilityTestReport);

        /**
         * <p>
         * An object that contains the results of the predictive inbox placement test.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeliverabilityTestReport.Builder}
         * avoiding the need to create one manually via {@link DeliverabilityTestReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeliverabilityTestReport.Builder#build()} is called immediately
         * and its result is passed to {@link #deliverabilityTestReport(DeliverabilityTestReport)}.
         * 
         * @param deliverabilityTestReport
         *        a consumer that will call methods on {@link DeliverabilityTestReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliverabilityTestReport(DeliverabilityTestReport)
         */
        default Builder deliverabilityTestReport(Consumer<DeliverabilityTestReport.Builder> deliverabilityTestReport) {
            return deliverabilityTestReport(DeliverabilityTestReport.builder().applyMutation(deliverabilityTestReport).build());
        }

        /**
         * <p>
         * An object that specifies how many test messages that were sent during the predictive inbox placement test
         * were delivered to recipients' inboxes, how many were sent to recipients' spam folders, and how many weren't
         * delivered.
         * </p>
         * 
         * @param overallPlacement
         *        An object that specifies how many test messages that were sent during the predictive inbox placement
         *        test were delivered to recipients' inboxes, how many were sent to recipients' spam folders, and how
         *        many weren't delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overallPlacement(PlacementStatistics overallPlacement);

        /**
         * <p>
         * An object that specifies how many test messages that were sent during the predictive inbox placement test
         * were delivered to recipients' inboxes, how many were sent to recipients' spam folders, and how many weren't
         * delivered.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlacementStatistics.Builder} avoiding the
         * need to create one manually via {@link PlacementStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlacementStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #overallPlacement(PlacementStatistics)}.
         * 
         * @param overallPlacement
         *        a consumer that will call methods on {@link PlacementStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overallPlacement(PlacementStatistics)
         */
        default Builder overallPlacement(Consumer<PlacementStatistics.Builder> overallPlacement) {
            return overallPlacement(PlacementStatistics.builder().applyMutation(overallPlacement).build());
        }

        /**
         * <p>
         * An object that describes how the test email was handled by several email providers, including Gmail, Hotmail,
         * Yahoo, AOL, and others.
         * </p>
         * 
         * @param ispPlacements
         *        An object that describes how the test email was handled by several email providers, including Gmail,
         *        Hotmail, Yahoo, AOL, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ispPlacements(Collection<IspPlacement> ispPlacements);

        /**
         * <p>
         * An object that describes how the test email was handled by several email providers, including Gmail, Hotmail,
         * Yahoo, AOL, and others.
         * </p>
         * 
         * @param ispPlacements
         *        An object that describes how the test email was handled by several email providers, including Gmail,
         *        Hotmail, Yahoo, AOL, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ispPlacements(IspPlacement... ispPlacements);

        /**
         * <p>
         * An object that describes how the test email was handled by several email providers, including Gmail, Hotmail,
         * Yahoo, AOL, and others.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.IspPlacement.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.IspPlacement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.IspPlacement.Builder#build()} is called immediately and
         * its result is passed to {@link #ispPlacements(List<IspPlacement>)}.
         * 
         * @param ispPlacements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.IspPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ispPlacements(java.util.Collection<IspPlacement>)
         */
        Builder ispPlacements(Consumer<IspPlacement.Builder>... ispPlacements);

        /**
         * <p>
         * An object that contains the message that you sent when you performed this predictive inbox placement test.
         * </p>
         * 
         * @param message
         *        An object that contains the message that you sent when you performed this predictive inbox placement
         *        test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the predictive inbox
         * placement test.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that are associated with the predictive
         *        inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the predictive inbox
         * placement test.
         * </p>
         * 
         * @param tags
         *        An array of objects that define the tags (keys and values) that are associated with the predictive
         *        inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of objects that define the tags (keys and values) that are associated with the predictive inbox
         * placement test.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sesv2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.sesv2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private DeliverabilityTestReport deliverabilityTestReport;

        private PlacementStatistics overallPlacement;

        private List<IspPlacement> ispPlacements = DefaultSdkAutoConstructList.getInstance();

        private String message;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeliverabilityTestReportResponse model) {
            super(model);
            deliverabilityTestReport(model.deliverabilityTestReport);
            overallPlacement(model.overallPlacement);
            ispPlacements(model.ispPlacements);
            message(model.message);
            tags(model.tags);
        }

        public final DeliverabilityTestReport.Builder getDeliverabilityTestReport() {
            return deliverabilityTestReport != null ? deliverabilityTestReport.toBuilder() : null;
        }

        public final void setDeliverabilityTestReport(DeliverabilityTestReport.BuilderImpl deliverabilityTestReport) {
            this.deliverabilityTestReport = deliverabilityTestReport != null ? deliverabilityTestReport.build() : null;
        }

        @Override
        public final Builder deliverabilityTestReport(DeliverabilityTestReport deliverabilityTestReport) {
            this.deliverabilityTestReport = deliverabilityTestReport;
            return this;
        }

        public final PlacementStatistics.Builder getOverallPlacement() {
            return overallPlacement != null ? overallPlacement.toBuilder() : null;
        }

        public final void setOverallPlacement(PlacementStatistics.BuilderImpl overallPlacement) {
            this.overallPlacement = overallPlacement != null ? overallPlacement.build() : null;
        }

        @Override
        public final Builder overallPlacement(PlacementStatistics overallPlacement) {
            this.overallPlacement = overallPlacement;
            return this;
        }

        public final List<IspPlacement.Builder> getIspPlacements() {
            List<IspPlacement.Builder> result = IspPlacementsCopier.copyToBuilder(this.ispPlacements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIspPlacements(Collection<IspPlacement.BuilderImpl> ispPlacements) {
            this.ispPlacements = IspPlacementsCopier.copyFromBuilder(ispPlacements);
        }

        @Override
        public final Builder ispPlacements(Collection<IspPlacement> ispPlacements) {
            this.ispPlacements = IspPlacementsCopier.copy(ispPlacements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ispPlacements(IspPlacement... ispPlacements) {
            ispPlacements(Arrays.asList(ispPlacements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ispPlacements(Consumer<IspPlacement.Builder>... ispPlacements) {
            ispPlacements(Stream.of(ispPlacements).map(c -> IspPlacement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeliverabilityTestReportResponse build() {
            return new GetDeliverabilityTestReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
