/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a <code>Bounce</code> object if the event type is <code>BOUNCE</code>. Contains a <code>Complaint</code>
 * object if the event type is <code>COMPLAINT</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventDetails implements SdkPojo, Serializable, ToCopyableBuilder<EventDetails.Builder, EventDetails> {
    private static final SdkField<Bounce> BOUNCE_FIELD = SdkField.<Bounce> builder(MarshallingType.SDK_POJO).memberName("Bounce")
            .getter(getter(EventDetails::bounce)).setter(setter(Builder::bounce)).constructor(Bounce::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bounce").build()).build();

    private static final SdkField<Complaint> COMPLAINT_FIELD = SdkField.<Complaint> builder(MarshallingType.SDK_POJO)
            .memberName("Complaint").getter(getter(EventDetails::complaint)).setter(setter(Builder::complaint))
            .constructor(Complaint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Complaint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(BOUNCE_FIELD, COMPLAINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Bounce bounce;

    private final Complaint complaint;

    private EventDetails(BuilderImpl builder) {
        this.bounce = builder.bounce;
        this.complaint = builder.complaint;
    }

    /**
     * <p>
     * Information about a <code>Bounce</code> event.
     * </p>
     * 
     * @return Information about a <code>Bounce</code> event.
     */
    public final Bounce bounce() {
        return bounce;
    }

    /**
     * <p>
     * Information about a <code>Complaint</code> event.
     * </p>
     * 
     * @return Information about a <code>Complaint</code> event.
     */
    public final Complaint complaint() {
        return complaint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bounce());
        hashCode = 31 * hashCode + Objects.hashCode(complaint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDetails)) {
            return false;
        }
        EventDetails other = (EventDetails) obj;
        return Objects.equals(bounce(), other.bounce()) && Objects.equals(complaint(), other.complaint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventDetails").add("Bounce", bounce()).add("Complaint", complaint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bounce":
            return Optional.ofNullable(clazz.cast(bounce()));
        case "Complaint":
            return Optional.ofNullable(clazz.cast(complaint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bounce", BOUNCE_FIELD);
        map.put("Complaint", COMPLAINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventDetails, T> g) {
        return obj -> g.apply((EventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventDetails> {
        /**
         * <p>
         * Information about a <code>Bounce</code> event.
         * </p>
         * 
         * @param bounce
         *        Information about a <code>Bounce</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounce(Bounce bounce);

        /**
         * <p>
         * Information about a <code>Bounce</code> event.
         * </p>
         * This is a convenience method that creates an instance of the {@link Bounce.Builder} avoiding the need to
         * create one manually via {@link Bounce#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Bounce.Builder#build()} is called immediately and its result is
         * passed to {@link #bounce(Bounce)}.
         * 
         * @param bounce
         *        a consumer that will call methods on {@link Bounce.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bounce(Bounce)
         */
        default Builder bounce(Consumer<Bounce.Builder> bounce) {
            return bounce(Bounce.builder().applyMutation(bounce).build());
        }

        /**
         * <p>
         * Information about a <code>Complaint</code> event.
         * </p>
         * 
         * @param complaint
         *        Information about a <code>Complaint</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complaint(Complaint complaint);

        /**
         * <p>
         * Information about a <code>Complaint</code> event.
         * </p>
         * This is a convenience method that creates an instance of the {@link Complaint.Builder} avoiding the need to
         * create one manually via {@link Complaint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Complaint.Builder#build()} is called immediately and its result
         * is passed to {@link #complaint(Complaint)}.
         * 
         * @param complaint
         *        a consumer that will call methods on {@link Complaint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complaint(Complaint)
         */
        default Builder complaint(Consumer<Complaint.Builder> complaint) {
            return complaint(Complaint.builder().applyMutation(complaint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Bounce bounce;

        private Complaint complaint;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDetails model) {
            bounce(model.bounce);
            complaint(model.complaint);
        }

        public final Bounce.Builder getBounce() {
            return bounce != null ? bounce.toBuilder() : null;
        }

        public final void setBounce(Bounce.BuilderImpl bounce) {
            this.bounce = bounce != null ? bounce.build() : null;
        }

        @Override
        public final Builder bounce(Bounce bounce) {
            this.bounce = bounce;
            return this;
        }

        public final Complaint.Builder getComplaint() {
            return complaint != null ? complaint.toBuilder() : null;
        }

        public final void setComplaint(Complaint.BuilderImpl complaint) {
            this.complaint = complaint != null ? complaint.build() : null;
        }

        @Override
        public final Builder complaint(Complaint complaint) {
            this.complaint = complaint;
            return this;
        }

        @Override
        public EventDetails build() {
            return new EventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
