/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a dedicated IP pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DedicatedIpPool implements SdkPojo, Serializable, ToCopyableBuilder<DedicatedIpPool.Builder, DedicatedIpPool> {
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(DedicatedIpPool::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<String> SCALING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingMode").getter(getter(DedicatedIpPool::scalingModeAsString)).setter(setter(Builder::scalingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_NAME_FIELD,
            SCALING_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String poolName;

    private final String scalingMode;

    private DedicatedIpPool(BuilderImpl builder) {
        this.poolName = builder.poolName;
        this.scalingMode = builder.scalingMode;
    }

    /**
     * <p>
     * The name of the dedicated IP pool.
     * </p>
     * 
     * @return The name of the dedicated IP pool.
     */
    public final String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The type of the dedicated IP pool.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically managed by
     * Amazon SES.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingMode} will
     * return {@link ScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingModeAsString}.
     * </p>
     * 
     * @return The type of the dedicated IP pool.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically
     *         managed by Amazon SES.
     *         </p>
     *         </li>
     * @see ScalingMode
     */
    public final ScalingMode scalingMode() {
        return ScalingMode.fromValue(scalingMode);
    }

    /**
     * <p>
     * The type of the dedicated IP pool.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically managed by
     * Amazon SES.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingMode} will
     * return {@link ScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingModeAsString}.
     * </p>
     * 
     * @return The type of the dedicated IP pool.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically
     *         managed by Amazon SES.
     *         </p>
     *         </li>
     * @see ScalingMode
     */
    public final String scalingModeAsString() {
        return scalingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DedicatedIpPool)) {
            return false;
        }
        DedicatedIpPool other = (DedicatedIpPool) obj;
        return Objects.equals(poolName(), other.poolName()) && Objects.equals(scalingModeAsString(), other.scalingModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DedicatedIpPool").add("PoolName", poolName()).add("ScalingMode", scalingModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "ScalingMode":
            return Optional.ofNullable(clazz.cast(scalingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("ScalingMode", SCALING_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DedicatedIpPool, T> g) {
        return obj -> g.apply((DedicatedIpPool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DedicatedIpPool> {
        /**
         * <p>
         * The name of the dedicated IP pool.
         * </p>
         * 
         * @param poolName
         *        The name of the dedicated IP pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The type of the dedicated IP pool.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically managed
         * by Amazon SES.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingMode
         *        The type of the dedicated IP pool.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically
         *        managed by Amazon SES.
         *        </p>
         *        </li>
         * @see ScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingMode
         */
        Builder scalingMode(String scalingMode);

        /**
         * <p>
         * The type of the dedicated IP pool.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically managed
         * by Amazon SES.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingMode
         *        The type of the dedicated IP pool.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> – A dedicated IP pool where you can control which IPs are part of the pool.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANAGED</code> – A dedicated IP pool where the reputation and number of IPs are automatically
         *        managed by Amazon SES.
         *        </p>
         *        </li>
         * @see ScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingMode
         */
        Builder scalingMode(ScalingMode scalingMode);
    }

    static final class BuilderImpl implements Builder {
        private String poolName;

        private String scalingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DedicatedIpPool model) {
            poolName(model.poolName);
            scalingMode(model.scalingMode);
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getScalingMode() {
            return scalingMode;
        }

        public final void setScalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
        }

        @Override
        public final Builder scalingMode(String scalingMode) {
            this.scalingMode = scalingMode;
            return this;
        }

        @Override
        public final Builder scalingMode(ScalingMode scalingMode) {
            this.scalingMode(scalingMode == null ? null : scalingMode.toString());
            return this;
        }

        @Override
        public DedicatedIpPool build() {
            return new DedicatedIpPool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
