/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a custom verification email template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomVerificationEmailTemplateMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomVerificationEmailTemplateMetadata.Builder, CustomVerificationEmailTemplateMetadata> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(CustomVerificationEmailTemplateMetadata::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromEmailAddress").getter(getter(CustomVerificationEmailTemplateMetadata::fromEmailAddress))
            .setter(setter(Builder::fromEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<String> TEMPLATE_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateSubject").getter(getter(CustomVerificationEmailTemplateMetadata::templateSubject))
            .setter(setter(Builder::templateSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateSubject").build()).build();

    private static final SdkField<String> SUCCESS_REDIRECTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SuccessRedirectionURL").getter(getter(CustomVerificationEmailTemplateMetadata::successRedirectionURL))
            .setter(setter(Builder::successRedirectionURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRedirectionURL").build())
            .build();

    private static final SdkField<String> FAILURE_REDIRECTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureRedirectionURL").getter(getter(CustomVerificationEmailTemplateMetadata::failureRedirectionURL))
            .setter(setter(Builder::failureRedirectionURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRedirectionURL").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            FROM_EMAIL_ADDRESS_FIELD, TEMPLATE_SUBJECT_FIELD, SUCCESS_REDIRECTION_URL_FIELD, FAILURE_REDIRECTION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String fromEmailAddress;

    private final String templateSubject;

    private final String successRedirectionURL;

    private final String failureRedirectionURL;

    private CustomVerificationEmailTemplateMetadata(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.templateSubject = builder.templateSubject;
        this.successRedirectionURL = builder.successRedirectionURL;
        this.failureRedirectionURL = builder.failureRedirectionURL;
    }

    /**
     * <p>
     * The name of the custom verification email template.
     * </p>
     * 
     * @return The name of the custom verification email template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The email address that the custom verification email is sent from.
     * </p>
     * 
     * @return The email address that the custom verification email is sent from.
     */
    public final String fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * The subject line of the custom verification email.
     * </p>
     * 
     * @return The subject line of the custom verification email.
     */
    public final String templateSubject() {
        return templateSubject;
    }

    /**
     * <p>
     * The URL that the recipient of the verification email is sent to if his or her address is successfully verified.
     * </p>
     * 
     * @return The URL that the recipient of the verification email is sent to if his or her address is successfully
     *         verified.
     */
    public final String successRedirectionURL() {
        return successRedirectionURL;
    }

    /**
     * <p>
     * The URL that the recipient of the verification email is sent to if his or her address is not successfully
     * verified.
     * </p>
     * 
     * @return The URL that the recipient of the verification email is sent to if his or her address is not successfully
     *         verified.
     */
    public final String failureRedirectionURL() {
        return failureRedirectionURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(templateSubject());
        hashCode = 31 * hashCode + Objects.hashCode(successRedirectionURL());
        hashCode = 31 * hashCode + Objects.hashCode(failureRedirectionURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomVerificationEmailTemplateMetadata)) {
            return false;
        }
        CustomVerificationEmailTemplateMetadata other = (CustomVerificationEmailTemplateMetadata) obj;
        return Objects.equals(templateName(), other.templateName())
                && Objects.equals(fromEmailAddress(), other.fromEmailAddress())
                && Objects.equals(templateSubject(), other.templateSubject())
                && Objects.equals(successRedirectionURL(), other.successRedirectionURL())
                && Objects.equals(failureRedirectionURL(), other.failureRedirectionURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomVerificationEmailTemplateMetadata").add("TemplateName", templateName())
                .add("FromEmailAddress", fromEmailAddress()).add("TemplateSubject", templateSubject())
                .add("SuccessRedirectionURL", successRedirectionURL()).add("FailureRedirectionURL", failureRedirectionURL())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "TemplateSubject":
            return Optional.ofNullable(clazz.cast(templateSubject()));
        case "SuccessRedirectionURL":
            return Optional.ofNullable(clazz.cast(successRedirectionURL()));
        case "FailureRedirectionURL":
            return Optional.ofNullable(clazz.cast(failureRedirectionURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
        map.put("TemplateSubject", TEMPLATE_SUBJECT_FIELD);
        map.put("SuccessRedirectionURL", SUCCESS_REDIRECTION_URL_FIELD);
        map.put("FailureRedirectionURL", FAILURE_REDIRECTION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomVerificationEmailTemplateMetadata, T> g) {
        return obj -> g.apply((CustomVerificationEmailTemplateMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomVerificationEmailTemplateMetadata> {
        /**
         * <p>
         * The name of the custom verification email template.
         * </p>
         * 
         * @param templateName
         *        The name of the custom verification email template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The email address that the custom verification email is sent from.
         * </p>
         * 
         * @param fromEmailAddress
         *        The email address that the custom verification email is sent from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(String fromEmailAddress);

        /**
         * <p>
         * The subject line of the custom verification email.
         * </p>
         * 
         * @param templateSubject
         *        The subject line of the custom verification email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSubject(String templateSubject);

        /**
         * <p>
         * The URL that the recipient of the verification email is sent to if his or her address is successfully
         * verified.
         * </p>
         * 
         * @param successRedirectionURL
         *        The URL that the recipient of the verification email is sent to if his or her address is successfully
         *        verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successRedirectionURL(String successRedirectionURL);

        /**
         * <p>
         * The URL that the recipient of the verification email is sent to if his or her address is not successfully
         * verified.
         * </p>
         * 
         * @param failureRedirectionURL
         *        The URL that the recipient of the verification email is sent to if his or her address is not
         *        successfully verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRedirectionURL(String failureRedirectionURL);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String fromEmailAddress;

        private String templateSubject;

        private String successRedirectionURL;

        private String failureRedirectionURL;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomVerificationEmailTemplateMetadata model) {
            templateName(model.templateName);
            fromEmailAddress(model.fromEmailAddress);
            templateSubject(model.templateSubject);
            successRedirectionURL(model.successRedirectionURL);
            failureRedirectionURL(model.failureRedirectionURL);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getFromEmailAddress() {
            return fromEmailAddress;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getTemplateSubject() {
            return templateSubject;
        }

        public final void setTemplateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
        }

        @Override
        public final Builder templateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
            return this;
        }

        public final String getSuccessRedirectionURL() {
            return successRedirectionURL;
        }

        public final void setSuccessRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
        }

        @Override
        public final Builder successRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
            return this;
        }

        public final String getFailureRedirectionURL() {
            return failureRedirectionURL;
        }

        public final void setFailureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
        }

        @Override
        public final Builder failureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
            return this;
        }

        @Override
        public CustomVerificationEmailTemplateMetadata build() {
            return new CustomVerificationEmailTemplateMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
