/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An HTTP 200 response if the request succeeds, or an error message if the request fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultiRegionEndpointResponse extends SesV2Response implements
        ToCopyableBuilder<CreateMultiRegionEndpointResponse.Builder, CreateMultiRegionEndpointResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateMultiRegionEndpointResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(CreateMultiRegionEndpointResponse::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            ENDPOINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String endpointId;

    private CreateMultiRegionEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.endpointId = builder.endpointId;
    }

    /**
     * <p>
     * A status of the multi-region endpoint (global-endpoint) right after the create request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The resource is being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> – The resource is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The resource failed to be provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> – The resource is being deleted as requested.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status of the multi-region endpoint (global-endpoint) right after the create request.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The resource is being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> – The resource is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The resource failed to be provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> – The resource is being deleted as requested.
     *         </p>
     *         </li>
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * A status of the multi-region endpoint (global-endpoint) right after the create request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> – The resource is being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> – The resource is ready to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> – The resource failed to be provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> – The resource is being deleted as requested.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status of the multi-region endpoint (global-endpoint) right after the create request.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> – The resource is being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> – The resource is ready to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> – The resource failed to be provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> – The resource is being deleted as requested.
     *         </p>
     *         </li>
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the multi-region endpoint (global-endpoint).
     * </p>
     * 
     * @return The ID of the multi-region endpoint (global-endpoint).
     */
    public final String endpointId() {
        return endpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionEndpointResponse)) {
            return false;
        }
        CreateMultiRegionEndpointResponse other = (CreateMultiRegionEndpointResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(endpointId(), other.endpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultiRegionEndpointResponse").add("Status", statusAsString())
                .add("EndpointId", endpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionEndpointResponse, T> g) {
        return obj -> g.apply((CreateMultiRegionEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateMultiRegionEndpointResponse> {
        /**
         * <p>
         * A status of the multi-region endpoint (global-endpoint) right after the create request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The resource is being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> – The resource is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The resource failed to be provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> – The resource is being deleted as requested.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A status of the multi-region endpoint (global-endpoint) right after the create request.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The resource is being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> – The resource is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The resource failed to be provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> – The resource is being deleted as requested.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * A status of the multi-region endpoint (global-endpoint) right after the create request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> – The resource is being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> – The resource is ready to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> – The resource failed to be provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> – The resource is being deleted as requested.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A status of the multi-region endpoint (global-endpoint) right after the create request.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> – The resource is being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> – The resource is ready to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> – The resource failed to be provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> – The resource is being deleted as requested.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The ID of the multi-region endpoint (global-endpoint).
         * </p>
         * 
         * @param endpointId
         *        The ID of the multi-region endpoint (global-endpoint).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String status;

        private String endpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionEndpointResponse model) {
            super(model);
            status(model.status);
            endpointId(model.endpointId);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        public CreateMultiRegionEndpointResponse build() {
            return new CreateMultiRegionEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
