/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about your account details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountDetails implements SdkPojo, Serializable, ToCopyableBuilder<AccountDetails.Builder, AccountDetails> {
    private static final SdkField<String> MAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MailType").getter(getter(AccountDetails::mailTypeAsString)).setter(setter(Builder::mailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailType").build()).build();

    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteURL").getter(getter(AccountDetails::websiteURL)).setter(setter(Builder::websiteURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteURL").build()).build();

    private static final SdkField<String> CONTACT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactLanguage").getter(getter(AccountDetails::contactLanguageAsString))
            .setter(setter(Builder::contactLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactLanguage").build()).build();

    private static final SdkField<String> USE_CASE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseDescription").getter(getter(AccountDetails::useCaseDescription))
            .setter(setter(Builder::useCaseDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseDescription").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalContactEmailAddresses")
            .getter(getter(AccountDetails::additionalContactEmailAddresses))
            .setter(setter(Builder::additionalContactEmailAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalContactEmailAddresses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReviewDetails> REVIEW_DETAILS_FIELD = SdkField
            .<ReviewDetails> builder(MarshallingType.SDK_POJO).memberName("ReviewDetails")
            .getter(getter(AccountDetails::reviewDetails)).setter(setter(Builder::reviewDetails))
            .constructor(ReviewDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_TYPE_FIELD,
            WEBSITE_URL_FIELD, CONTACT_LANGUAGE_FIELD, USE_CASE_DESCRIPTION_FIELD, ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD,
            REVIEW_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mailType;

    private final String websiteURL;

    private final String contactLanguage;

    private final String useCaseDescription;

    private final List<String> additionalContactEmailAddresses;

    private final ReviewDetails reviewDetails;

    private AccountDetails(BuilderImpl builder) {
        this.mailType = builder.mailType;
        this.websiteURL = builder.websiteURL;
        this.contactLanguage = builder.contactLanguage;
        this.useCaseDescription = builder.useCaseDescription;
        this.additionalContactEmailAddresses = builder.additionalContactEmailAddresses;
        this.reviewDetails = builder.reviewDetails;
    }

    /**
     * <p>
     * The type of email your account is sending. The mail type can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your latest offering.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with a customer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mailType} will
     * return {@link MailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mailTypeAsString}.
     * </p>
     * 
     * @return The type of email your account is sending. The mail type can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your latest
     *         offering.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with a
     *         customer.
     *         </p>
     *         </li>
     * @see MailType
     */
    public final MailType mailType() {
        return MailType.fromValue(mailType);
    }

    /**
     * <p>
     * The type of email your account is sending. The mail type can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your latest offering.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with a customer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mailType} will
     * return {@link MailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mailTypeAsString}.
     * </p>
     * 
     * @return The type of email your account is sending. The mail type can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your latest
     *         offering.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with a
     *         customer.
     *         </p>
     *         </li>
     * @see MailType
     */
    public final String mailTypeAsString() {
        return mailType;
    }

    /**
     * <p>
     * The URL of your website. This information helps us better understand the type of content that you plan to send.
     * </p>
     * 
     * @return The URL of your website. This information helps us better understand the type of content that you plan to
     *         send.
     */
    public final String websiteURL() {
        return websiteURL;
    }

    /**
     * <p>
     * The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
     * <code>JAPANESE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactLanguage}
     * will return {@link ContactLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactLanguageAsString}.
     * </p>
     * 
     * @return The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
     *         <code>JAPANESE</code>.
     * @see ContactLanguage
     */
    public final ContactLanguage contactLanguage() {
        return ContactLanguage.fromValue(contactLanguage);
    }

    /**
     * <p>
     * The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
     * <code>JAPANESE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactLanguage}
     * will return {@link ContactLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactLanguageAsString}.
     * </p>
     * 
     * @return The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
     *         <code>JAPANESE</code>.
     * @see ContactLanguage
     */
    public final String contactLanguageAsString() {
        return contactLanguage;
    }

    /**
     * <p>
     * A description of the types of email that you plan to send.
     * </p>
     * 
     * @return A description of the types of email that you plan to send.
     */
    public final String useCaseDescription() {
        return useCaseDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalContactEmailAddresses
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalContactEmailAddresses() {
        return additionalContactEmailAddresses != null && !(additionalContactEmailAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional email addresses where updates are sent about your account review process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalContactEmailAddresses}
     * method.
     * </p>
     * 
     * @return Additional email addresses where updates are sent about your account review process.
     */
    public final List<String> additionalContactEmailAddresses() {
        return additionalContactEmailAddresses;
    }

    /**
     * <p>
     * Information about the review of the latest details you submitted.
     * </p>
     * 
     * @return Information about the review of the latest details you submitted.
     */
    public final ReviewDetails reviewDetails() {
        return reviewDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(websiteURL());
        hashCode = 31 * hashCode + Objects.hashCode(contactLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseDescription());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalContactEmailAddresses() ? additionalContactEmailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reviewDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountDetails)) {
            return false;
        }
        AccountDetails other = (AccountDetails) obj;
        return Objects.equals(mailTypeAsString(), other.mailTypeAsString()) && Objects.equals(websiteURL(), other.websiteURL())
                && Objects.equals(contactLanguageAsString(), other.contactLanguageAsString())
                && Objects.equals(useCaseDescription(), other.useCaseDescription())
                && hasAdditionalContactEmailAddresses() == other.hasAdditionalContactEmailAddresses()
                && Objects.equals(additionalContactEmailAddresses(), other.additionalContactEmailAddresses())
                && Objects.equals(reviewDetails(), other.reviewDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AccountDetails")
                .add("MailType", mailTypeAsString())
                .add("WebsiteURL", websiteURL() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContactLanguage", contactLanguageAsString())
                .add("UseCaseDescription", useCaseDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AdditionalContactEmailAddresses",
                        additionalContactEmailAddresses() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReviewDetails", reviewDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailType":
            return Optional.ofNullable(clazz.cast(mailTypeAsString()));
        case "WebsiteURL":
            return Optional.ofNullable(clazz.cast(websiteURL()));
        case "ContactLanguage":
            return Optional.ofNullable(clazz.cast(contactLanguageAsString()));
        case "UseCaseDescription":
            return Optional.ofNullable(clazz.cast(useCaseDescription()));
        case "AdditionalContactEmailAddresses":
            return Optional.ofNullable(clazz.cast(additionalContactEmailAddresses()));
        case "ReviewDetails":
            return Optional.ofNullable(clazz.cast(reviewDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MailType", MAIL_TYPE_FIELD);
        map.put("WebsiteURL", WEBSITE_URL_FIELD);
        map.put("ContactLanguage", CONTACT_LANGUAGE_FIELD);
        map.put("UseCaseDescription", USE_CASE_DESCRIPTION_FIELD);
        map.put("AdditionalContactEmailAddresses", ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD);
        map.put("ReviewDetails", REVIEW_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountDetails, T> g) {
        return obj -> g.apply((AccountDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountDetails> {
        /**
         * <p>
         * The type of email your account is sending. The mail type can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your latest
         * offering.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with a
         * customer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mailType
         *        The type of email your account is sending. The mail type can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your
         *        latest offering.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with
         *        a customer.
         *        </p>
         *        </li>
         * @see MailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailType
         */
        Builder mailType(String mailType);

        /**
         * <p>
         * The type of email your account is sending. The mail type can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your latest
         * offering.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with a
         * customer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mailType
         *        The type of email your account is sending. The mail type can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your
         *        latest offering.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with
         *        a customer.
         *        </p>
         *        </li>
         * @see MailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailType
         */
        Builder mailType(MailType mailType);

        /**
         * <p>
         * The URL of your website. This information helps us better understand the type of content that you plan to
         * send.
         * </p>
         * 
         * @param websiteURL
         *        The URL of your website. This information helps us better understand the type of content that you plan
         *        to send.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteURL(String websiteURL);

        /**
         * <p>
         * The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
         * <code>JAPANESE</code>.
         * </p>
         * 
         * @param contactLanguage
         *        The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
         *        <code>JAPANESE</code>.
         * @see ContactLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactLanguage
         */
        Builder contactLanguage(String contactLanguage);

        /**
         * <p>
         * The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
         * <code>JAPANESE</code>.
         * </p>
         * 
         * @param contactLanguage
         *        The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or
         *        <code>JAPANESE</code>.
         * @see ContactLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactLanguage
         */
        Builder contactLanguage(ContactLanguage contactLanguage);

        /**
         * <p>
         * A description of the types of email that you plan to send.
         * </p>
         * 
         * @param useCaseDescription
         *        A description of the types of email that you plan to send.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCaseDescription(String useCaseDescription);

        /**
         * <p>
         * Additional email addresses where updates are sent about your account review process.
         * </p>
         * 
         * @param additionalContactEmailAddresses
         *        Additional email addresses where updates are sent about your account review process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses);

        /**
         * <p>
         * Additional email addresses where updates are sent about your account review process.
         * </p>
         * 
         * @param additionalContactEmailAddresses
         *        Additional email addresses where updates are sent about your account review process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalContactEmailAddresses(String... additionalContactEmailAddresses);

        /**
         * <p>
         * Information about the review of the latest details you submitted.
         * </p>
         * 
         * @param reviewDetails
         *        Information about the review of the latest details you submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewDetails(ReviewDetails reviewDetails);

        /**
         * <p>
         * Information about the review of the latest details you submitted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReviewDetails.Builder} avoiding the need
         * to create one manually via {@link ReviewDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReviewDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #reviewDetails(ReviewDetails)}.
         * 
         * @param reviewDetails
         *        a consumer that will call methods on {@link ReviewDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reviewDetails(ReviewDetails)
         */
        default Builder reviewDetails(Consumer<ReviewDetails.Builder> reviewDetails) {
            return reviewDetails(ReviewDetails.builder().applyMutation(reviewDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mailType;

        private String websiteURL;

        private String contactLanguage;

        private String useCaseDescription;

        private List<String> additionalContactEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private ReviewDetails reviewDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountDetails model) {
            mailType(model.mailType);
            websiteURL(model.websiteURL);
            contactLanguage(model.contactLanguage);
            useCaseDescription(model.useCaseDescription);
            additionalContactEmailAddresses(model.additionalContactEmailAddresses);
            reviewDetails(model.reviewDetails);
        }

        public final String getMailType() {
            return mailType;
        }

        public final void setMailType(String mailType) {
            this.mailType = mailType;
        }

        @Override
        public final Builder mailType(String mailType) {
            this.mailType = mailType;
            return this;
        }

        @Override
        public final Builder mailType(MailType mailType) {
            this.mailType(mailType == null ? null : mailType.toString());
            return this;
        }

        public final String getWebsiteURL() {
            return websiteURL;
        }

        public final void setWebsiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
        }

        @Override
        public final Builder websiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
            return this;
        }

        public final String getContactLanguage() {
            return contactLanguage;
        }

        public final void setContactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
        }

        @Override
        public final Builder contactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
            return this;
        }

        @Override
        public final Builder contactLanguage(ContactLanguage contactLanguage) {
            this.contactLanguage(contactLanguage == null ? null : contactLanguage.toString());
            return this;
        }

        public final String getUseCaseDescription() {
            return useCaseDescription;
        }

        public final void setUseCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
        }

        @Override
        public final Builder useCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
            return this;
        }

        public final Collection<String> getAdditionalContactEmailAddresses() {
            if (additionalContactEmailAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalContactEmailAddresses;
        }

        public final void setAdditionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
        }

        @Override
        public final Builder additionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalContactEmailAddresses(String... additionalContactEmailAddresses) {
            additionalContactEmailAddresses(Arrays.asList(additionalContactEmailAddresses));
            return this;
        }

        public final ReviewDetails.Builder getReviewDetails() {
            return reviewDetails != null ? reviewDetails.toBuilder() : null;
        }

        public final void setReviewDetails(ReviewDetails.BuilderImpl reviewDetails) {
            this.reviewDetails = reviewDetails != null ? reviewDetails.build() : null;
        }

        @Override
        public final Builder reviewDetails(ReviewDetails reviewDetails) {
            this.reviewDetails = reviewDetails;
            return this;
        }

        @Override
        public AccountDetails build() {
            return new AccountDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
