/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.DashboardOptions;
import software.amazon.awssdk.services.sesv2.model.GuardianOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VdmOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VdmOptions> {
    private static final SdkField<DashboardOptions> DASHBOARD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashboardOptions").getter(VdmOptions.getter(VdmOptions::dashboardOptions)).setter(VdmOptions.setter(Builder::dashboardOptions)).constructor(DashboardOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardOptions").build()}).build();
    private static final SdkField<GuardianOptions> GUARDIAN_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GuardianOptions").getter(VdmOptions.getter(VdmOptions::guardianOptions)).setter(VdmOptions.setter(Builder::guardianOptions)).constructor(GuardianOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardianOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_OPTIONS_FIELD, GUARDIAN_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VdmOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DashboardOptions dashboardOptions;
    private final GuardianOptions guardianOptions;

    private VdmOptions(BuilderImpl builder) {
        this.dashboardOptions = builder.dashboardOptions;
        this.guardianOptions = builder.guardianOptions;
    }

    public final DashboardOptions dashboardOptions() {
        return this.dashboardOptions;
    }

    public final GuardianOptions guardianOptions() {
        return this.guardianOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardianOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VdmOptions)) {
            return false;
        }
        VdmOptions other = (VdmOptions)obj;
        return Objects.equals(this.dashboardOptions(), other.dashboardOptions()) && Objects.equals(this.guardianOptions(), other.guardianOptions());
    }

    public final String toString() {
        return ToString.builder((String)"VdmOptions").add("DashboardOptions", (Object)this.dashboardOptions()).add("GuardianOptions", (Object)this.guardianOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardOptions": {
                return Optional.ofNullable(clazz.cast(this.dashboardOptions()));
            }
            case "GuardianOptions": {
                return Optional.ofNullable(clazz.cast(this.guardianOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DashboardOptions", DASHBOARD_OPTIONS_FIELD);
        map.put("GuardianOptions", GUARDIAN_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VdmOptions, T> g) {
        return obj -> g.apply((VdmOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DashboardOptions dashboardOptions;
        private GuardianOptions guardianOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VdmOptions model) {
            this.dashboardOptions(model.dashboardOptions);
            this.guardianOptions(model.guardianOptions);
        }

        public final DashboardOptions.Builder getDashboardOptions() {
            return this.dashboardOptions != null ? this.dashboardOptions.toBuilder() : null;
        }

        public final void setDashboardOptions(DashboardOptions.BuilderImpl dashboardOptions) {
            this.dashboardOptions = dashboardOptions != null ? dashboardOptions.build() : null;
        }

        @Override
        public final Builder dashboardOptions(DashboardOptions dashboardOptions) {
            this.dashboardOptions = dashboardOptions;
            return this;
        }

        public final GuardianOptions.Builder getGuardianOptions() {
            return this.guardianOptions != null ? this.guardianOptions.toBuilder() : null;
        }

        public final void setGuardianOptions(GuardianOptions.BuilderImpl guardianOptions) {
            this.guardianOptions = guardianOptions != null ? guardianOptions.build() : null;
        }

        @Override
        public final Builder guardianOptions(GuardianOptions guardianOptions) {
            this.guardianOptions = guardianOptions;
            return this;
        }

        public VdmOptions build() {
            return new VdmOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VdmOptions> {
        public Builder dashboardOptions(DashboardOptions var1);

        default public Builder dashboardOptions(Consumer<DashboardOptions.Builder> dashboardOptions) {
            return this.dashboardOptions((DashboardOptions)((DashboardOptions.Builder)DashboardOptions.builder().applyMutation(dashboardOptions)).build());
        }

        public Builder guardianOptions(GuardianOptions var1);

        default public Builder guardianOptions(Consumer<GuardianOptions.Builder> guardianOptions) {
            return this.guardianOptions((GuardianOptions)((GuardianOptions.Builder)GuardianOptions.builder().applyMutation(guardianOptions)).build());
        }
    }
}

