/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse;

public class ListExportJobsIterable
implements SdkIterable<ListExportJobsResponse> {
    private final SesV2Client client;
    private final ListExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExportJobsIterable(SesV2Client client, ListExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExportJobsResponseFetcher();
    }

    public Iterator<ListExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExportJobsResponseFetcher
    implements SyncPageFetcher<ListExportJobsResponse> {
        private ListExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExportJobsResponse nextPage(ListExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListExportJobsIterable.this.client.listExportJobs(ListExportJobsIterable.this.firstRequest);
            }
            return ListExportJobsIterable.this.client.listExportJobs((ListExportJobsRequest)((Object)ListExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

