/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;

public class ListEmailIdentitiesIterable
implements SdkIterable<ListEmailIdentitiesResponse> {
    private final SesV2Client client;
    private final ListEmailIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEmailIdentitiesIterable(SesV2Client client, ListEmailIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEmailIdentitiesResponseFetcher();
    }

    public Iterator<ListEmailIdentitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEmailIdentitiesResponseFetcher
    implements SyncPageFetcher<ListEmailIdentitiesResponse> {
        private ListEmailIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEmailIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEmailIdentitiesResponse nextPage(ListEmailIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEmailIdentitiesIterable.this.client.listEmailIdentities(ListEmailIdentitiesIterable.this.firstRequest);
            }
            return ListEmailIdentitiesIterable.this.client.listEmailIdentities((ListEmailIdentitiesRequest)((Object)ListEmailIdentitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

