/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A recommendation generated for your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recommendation implements SdkPojo, Serializable, ToCopyableBuilder<Recommendation.Builder, Recommendation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(Recommendation::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Recommendation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Recommendation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Recommendation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(Recommendation::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(Recommendation::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> IMPACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Impact")
            .getter(getter(Recommendation::impactAsString)).setter(setter(Builder::impact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TYPE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, IMPACT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String type;

    private final String description;

    private final String status;

    private final Instant createdTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final String impact;

    private Recommendation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.type = builder.type;
        this.description = builder.description;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.impact = builder.impact;
    }

    /**
     * <p>
     * The resource affected by the recommendation, with values like
     * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
     * </p>
     * 
     * @return The resource affected by the recommendation, with values like
     *         <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
     * <code>BIMI</code>, or <code>COMPLAINT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
     *         <code>BIMI</code>, or <code>COMPLAINT</code>.
     * @see RecommendationType
     */
    public final RecommendationType type() {
        return RecommendationType.fromValue(type);
    }

    /**
     * <p>
     * The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
     * <code>BIMI</code>, or <code>COMPLAINT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
     *         <code>BIMI</code>, or <code>COMPLAINT</code>.
     * @see RecommendationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The recommendation description / disambiguator - e.g. <code>DKIM1</code> and <code>DKIM2</code> are different
     * recommendations about your DKIM setup.
     * </p>
     * 
     * @return The recommendation description / disambiguator - e.g. <code>DKIM1</code> and <code>DKIM2</code> are
     *         different recommendations about your DKIM setup.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
     * @see RecommendationStatus
     */
    public final RecommendationStatus status() {
        return RecommendationStatus.fromValue(status);
    }

    /**
     * <p>
     * The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
     * @see RecommendationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The first time this issue was encountered and the recommendation was generated.
     * </p>
     * 
     * @return The first time this issue was encountered and the recommendation was generated.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The last time the recommendation was updated.
     * </p>
     * 
     * @return The last time the recommendation was updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #impact} will
     * return {@link RecommendationImpact#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #impactAsString}.
     * </p>
     * 
     * @return The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
     * @see RecommendationImpact
     */
    public final RecommendationImpact impact() {
        return RecommendationImpact.fromValue(impact);
    }

    /**
     * <p>
     * The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #impact} will
     * return {@link RecommendationImpact#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #impactAsString}.
     * </p>
     * 
     * @return The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
     * @see RecommendationImpact
     */
    public final String impactAsString() {
        return impact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(impactAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(impactAsString(), other.impactAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recommendation").add("ResourceArn", resourceArn()).add("Type", typeAsString())
                .add("Description", description()).add("Status", statusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("Impact", impactAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "Impact":
            return Optional.ofNullable(clazz.cast(impactAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("Impact", IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recommendation> {
        /**
         * <p>
         * The resource affected by the recommendation, with values like
         * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * </p>
         * 
         * @param resourceArn
         *        The resource affected by the recommendation, with values like
         *        <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
         * <code>BIMI</code>, or <code>COMPLAINT</code>.
         * </p>
         * 
         * @param type
         *        The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
         *        <code>BIMI</code>, or <code>COMPLAINT</code>.
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder type(String type);

        /**
         * <p>
         * The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
         * <code>BIMI</code>, or <code>COMPLAINT</code>.
         * </p>
         * 
         * @param type
         *        The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>,
         *        <code>BIMI</code>, or <code>COMPLAINT</code>.
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder type(RecommendationType type);

        /**
         * <p>
         * The recommendation description / disambiguator - e.g. <code>DKIM1</code> and <code>DKIM2</code> are different
         * recommendations about your DKIM setup.
         * </p>
         * 
         * @param description
         *        The recommendation description / disambiguator - e.g. <code>DKIM1</code> and <code>DKIM2</code> are
         *        different recommendations about your DKIM setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
         * </p>
         * 
         * @param status
         *        The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
         * </p>
         * 
         * @param status
         *        The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder status(RecommendationStatus status);

        /**
         * <p>
         * The first time this issue was encountered and the recommendation was generated.
         * </p>
         * 
         * @param createdTimestamp
         *        The first time this issue was encountered and the recommendation was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The last time the recommendation was updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The last time the recommendation was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
         * </p>
         * 
         * @param impact
         *        The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
         * @see RecommendationImpact
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationImpact
         */
        Builder impact(String impact);

        /**
         * <p>
         * The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
         * </p>
         * 
         * @param impact
         *        The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
         * @see RecommendationImpact
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationImpact
         */
        Builder impact(RecommendationImpact impact);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String type;

        private String description;

        private String status;

        private Instant createdTimestamp;

        private Instant lastUpdatedTimestamp;

        private String impact;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            resourceArn(model.resourceArn);
            type(model.type);
            description(model.description);
            status(model.status);
            createdTimestamp(model.createdTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            impact(model.impact);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getImpact() {
            return impact;
        }

        public final void setImpact(String impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(String impact) {
            this.impact = impact;
            return this;
        }

        @Override
        public final Builder impact(RecommendationImpact impact) {
            this.impact(impact == null ? null : impact.toString());
            return this;
        }

        @Override
        public Recommendation build() {
            return new Recommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
