/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
 * reputation, deliverability, and other metrics for the domains that you use to send email using Amazon SES API v2. You
 * also gain the ability to perform predictive inbox placement tests.
 * </p>
 * <p>
 * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that
 * you accrue by using Amazon SES and other Amazon Web Services services. For more information about the features and
 * cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon
 * Pinpoint Pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDeliverabilityDashboardOptionRequest extends SesV2Request implements
        ToCopyableBuilder<PutDeliverabilityDashboardOptionRequest.Builder, PutDeliverabilityDashboardOptionRequest> {
    private static final SdkField<Boolean> DASHBOARD_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DashboardEnabled").getter(getter(PutDeliverabilityDashboardOptionRequest::dashboardEnabled))
            .setter(setter(Builder::dashboardEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardEnabled").build()).build();

    private static final SdkField<List<DomainDeliverabilityTrackingOption>> SUBSCRIBED_DOMAINS_FIELD = SdkField
            .<List<DomainDeliverabilityTrackingOption>> builder(MarshallingType.LIST)
            .memberName("SubscribedDomains")
            .getter(getter(PutDeliverabilityDashboardOptionRequest::subscribedDomains))
            .setter(setter(Builder::subscribedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainDeliverabilityTrackingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainDeliverabilityTrackingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ENABLED_FIELD,
            SUBSCRIBED_DOMAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dashboardEnabled;

    private final List<DomainDeliverabilityTrackingOption> subscribedDomains;

    private PutDeliverabilityDashboardOptionRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardEnabled = builder.dashboardEnabled;
        this.subscribedDomains = builder.subscribedDomains;
    }

    /**
     * <p>
     * Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to
     * <code>true</code>.
     * </p>
     * 
     * @return Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to
     *         <code>true</code>.
     */
    public final Boolean dashboardEnabled() {
        return dashboardEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscribedDomains property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribedDomains() {
        return subscribedDomains != null && !(subscribedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each verified domain that you use to send email and enabled the Deliverability
     * dashboard for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribedDomains} method.
     * </p>
     * 
     * @return An array of objects, one for each verified domain that you use to send email and enabled the
     *         Deliverability dashboard for.
     */
    public final List<DomainDeliverabilityTrackingOption> subscribedDomains() {
        return subscribedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribedDomains() ? subscribedDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliverabilityDashboardOptionRequest)) {
            return false;
        }
        PutDeliverabilityDashboardOptionRequest other = (PutDeliverabilityDashboardOptionRequest) obj;
        return Objects.equals(dashboardEnabled(), other.dashboardEnabled())
                && hasSubscribedDomains() == other.hasSubscribedDomains()
                && Objects.equals(subscribedDomains(), other.subscribedDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDeliverabilityDashboardOptionRequest").add("DashboardEnabled", dashboardEnabled())
                .add("SubscribedDomains", hasSubscribedDomains() ? subscribedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardEnabled":
            return Optional.ofNullable(clazz.cast(dashboardEnabled()));
        case "SubscribedDomains":
            return Optional.ofNullable(clazz.cast(subscribedDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardEnabled", DASHBOARD_ENABLED_FIELD);
        map.put("SubscribedDomains", SUBSCRIBED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDeliverabilityDashboardOptionRequest, T> g) {
        return obj -> g.apply((PutDeliverabilityDashboardOptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDeliverabilityDashboardOptionRequest> {
        /**
         * <p>
         * Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to
         * <code>true</code>.
         * </p>
         * 
         * @param dashboardEnabled
         *        Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardEnabled(Boolean dashboardEnabled);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and enabled the Deliverability
         * dashboard for.
         * </p>
         * 
         * @param subscribedDomains
         *        An array of objects, one for each verified domain that you use to send email and enabled the
         *        Deliverability dashboard for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedDomains(Collection<DomainDeliverabilityTrackingOption> subscribedDomains);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and enabled the Deliverability
         * dashboard for.
         * </p>
         * 
         * @param subscribedDomains
         *        An array of objects, one for each verified domain that you use to send email and enabled the
         *        Deliverability dashboard for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedDomains(DomainDeliverabilityTrackingOption... subscribedDomains);

        /**
         * <p>
         * An array of objects, one for each verified domain that you use to send email and enabled the Deliverability
         * dashboard for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #subscribedDomains(List<DomainDeliverabilityTrackingOption>)}.
         * 
         * @param subscribedDomains
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedDomains(java.util.Collection<DomainDeliverabilityTrackingOption>)
         */
        Builder subscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder>... subscribedDomains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private Boolean dashboardEnabled;

        private List<DomainDeliverabilityTrackingOption> subscribedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliverabilityDashboardOptionRequest model) {
            super(model);
            dashboardEnabled(model.dashboardEnabled);
            subscribedDomains(model.subscribedDomains);
        }

        public final Boolean getDashboardEnabled() {
            return dashboardEnabled;
        }

        public final void setDashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
        }

        @Override
        public final Builder dashboardEnabled(Boolean dashboardEnabled) {
            this.dashboardEnabled = dashboardEnabled;
            return this;
        }

        public final List<DomainDeliverabilityTrackingOption.Builder> getSubscribedDomains() {
            List<DomainDeliverabilityTrackingOption.Builder> result = DomainDeliverabilityTrackingOptionsCopier
                    .copyToBuilder(this.subscribedDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedDomains(Collection<DomainDeliverabilityTrackingOption.BuilderImpl> subscribedDomains) {
            this.subscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copyFromBuilder(subscribedDomains);
        }

        @Override
        public final Builder subscribedDomains(Collection<DomainDeliverabilityTrackingOption> subscribedDomains) {
            this.subscribedDomains = DomainDeliverabilityTrackingOptionsCopier.copy(subscribedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedDomains(DomainDeliverabilityTrackingOption... subscribedDomains) {
            subscribedDomains(Arrays.asList(subscribedDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedDomains(Consumer<DomainDeliverabilityTrackingOption.Builder>... subscribedDomains) {
            subscribedDomains(Stream.of(subscribedDomains)
                    .map(c -> DomainDeliverabilityTrackingOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeliverabilityDashboardOptionRequest build() {
            return new PutDeliverabilityDashboardOptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
