/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.auth.scheme.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sesv2.auth.scheme.SesV2AuthSchemeParams;
import software.amazon.awssdk.services.sesv2.auth.scheme.internal.SesV2EndpointResolverAware;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultSesV2AuthSchemeParams
implements SesV2AuthSchemeParams,
SesV2EndpointResolverAware {
    private final String operation;
    private final Region region;
    private final Boolean useDualStack;
    private final Boolean useFIPS;
    private final String endpoint;
    private final String endpointId;
    private final SesV2EndpointProvider endpointProvider;

    private DefaultSesV2AuthSchemeParams(Builder builder) {
        this.operation = (String)Validate.paramNotNull((Object)builder.operation, (String)"operation");
        this.region = builder.region;
        this.useDualStack = (Boolean)Validate.paramNotNull((Object)builder.useDualStack, (String)"useDualStack");
        this.useFIPS = (Boolean)Validate.paramNotNull((Object)builder.useFIPS, (String)"useFIPS");
        this.endpoint = builder.endpoint;
        this.endpointId = builder.endpointId;
        this.endpointProvider = builder.endpointProvider;
    }

    public static SesV2AuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public Boolean useDualStack() {
        return this.useDualStack;
    }

    @Override
    public Boolean useFips() {
        return this.useFIPS;
    }

    @Override
    public String endpoint() {
        return this.endpoint;
    }

    @Override
    public String endpointId() {
        return this.endpointId;
    }

    @Override
    public SesV2EndpointProvider endpointProvider() {
        return this.endpointProvider;
    }

    @Override
    public SesV2AuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder
    implements SesV2AuthSchemeParams.Builder,
    SesV2EndpointResolverAware.Builder {
        private String operation;
        private Region region;
        private Boolean useDualStack = false;
        private Boolean useFIPS = false;
        private String endpoint;
        private String endpointId;
        private SesV2EndpointProvider endpointProvider;

        Builder() {
        }

        Builder(DefaultSesV2AuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
            this.useDualStack = params.useDualStack;
            this.useFIPS = params.useFIPS;
            this.endpoint = params.endpoint;
            this.endpointId = params.endpointId;
            this.endpointProvider = params.endpointProvider;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @Override
        public Builder endpointProvider(SesV2EndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        @Override
        public SesV2AuthSchemeParams build() {
            return new DefaultSesV2AuthSchemeParams(this);
        }
    }
}

