/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary that describes the suppressed email address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuppressedDestinationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SuppressedDestinationSummary.Builder, SuppressedDestinationSummary> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(SuppressedDestinationSummary::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(SuppressedDestinationSummary::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(SuppressedDestinationSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD,
            REASON_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EmailAddress", EMAIL_ADDRESS_FIELD);
                    put("Reason", REASON_FIELD);
                    put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String emailAddress;

    private final String reason;

    private final Instant lastUpdateTime;

    private SuppressedDestinationSummary(BuilderImpl builder) {
        this.emailAddress = builder.emailAddress;
        this.reason = builder.reason;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The email address that's on the suppression list for your account.
     * </p>
     * 
     * @return The email address that's on the suppression list for your account.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The reason that the address was added to the suppression list for your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SuppressionListReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason that the address was added to the suppression list for your account.
     * @see SuppressionListReason
     */
    public final SuppressionListReason reason() {
        return SuppressionListReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason that the address was added to the suppression list for your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SuppressionListReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason that the address was added to the suppression list for your account.
     * @see SuppressionListReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The date and time when the suppressed destination was last updated, shown in Unix time format.
     * </p>
     * 
     * @return The date and time when the suppressed destination was last updated, shown in Unix time format.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressedDestinationSummary)) {
            return false;
        }
        SuppressedDestinationSummary other = (SuppressedDestinationSummary) obj;
        return Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuppressedDestinationSummary").add("EmailAddress", emailAddress())
                .add("Reason", reasonAsString()).add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SuppressedDestinationSummary, T> g) {
        return obj -> g.apply((SuppressedDestinationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuppressedDestinationSummary> {
        /**
         * <p>
         * The email address that's on the suppression list for your account.
         * </p>
         * 
         * @param emailAddress
         *        The email address that's on the suppression list for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The reason that the address was added to the suppression list for your account.
         * </p>
         * 
         * @param reason
         *        The reason that the address was added to the suppression list for your account.
         * @see SuppressionListReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionListReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason that the address was added to the suppression list for your account.
         * </p>
         * 
         * @param reason
         *        The reason that the address was added to the suppression list for your account.
         * @see SuppressionListReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionListReason
         */
        Builder reason(SuppressionListReason reason);

        /**
         * <p>
         * The date and time when the suppressed destination was last updated, shown in Unix time format.
         * </p>
         * 
         * @param lastUpdateTime
         *        The date and time when the suppressed destination was last updated, shown in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String emailAddress;

        private String reason;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressedDestinationSummary model) {
            emailAddress(model.emailAddress);
            reason(model.reason);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SuppressionListReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public SuppressedDestinationSummary build() {
            return new SuppressedDestinationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
