/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that can be applied to a list of contacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListContactsFilter.Builder, ListContactsFilter> {
    private static final SdkField<String> FILTERED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilteredStatus").getter(getter(ListContactsFilter::filteredStatusAsString))
            .setter(setter(Builder::filteredStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilteredStatus").build()).build();

    private static final SdkField<TopicFilter> TOPIC_FILTER_FIELD = SdkField.<TopicFilter> builder(MarshallingType.SDK_POJO)
            .memberName("TopicFilter").getter(getter(ListContactsFilter::topicFilter)).setter(setter(Builder::topicFilter))
            .constructor(TopicFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERED_STATUS_FIELD,
            TOPIC_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FilteredStatus", FILTERED_STATUS_FIELD);
                    put("TopicFilter", TOPIC_FILTER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String filteredStatus;

    private final TopicFilter topicFilter;

    private ListContactsFilter(BuilderImpl builder) {
        this.filteredStatus = builder.filteredStatus;
        this.topicFilter = builder.topicFilter;
    }

    /**
     * <p>
     * The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filteredStatus}
     * will return {@link SubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filteredStatusAsString}.
     * </p>
     * 
     * @return The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
     * @see SubscriptionStatus
     */
    public final SubscriptionStatus filteredStatus() {
        return SubscriptionStatus.fromValue(filteredStatus);
    }

    /**
     * <p>
     * The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filteredStatus}
     * will return {@link SubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filteredStatusAsString}.
     * </p>
     * 
     * @return The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
     * @see SubscriptionStatus
     */
    public final String filteredStatusAsString() {
        return filteredStatus;
    }

    /**
     * <p>
     * Used for filtering by a specific topic preference.
     * </p>
     * 
     * @return Used for filtering by a specific topic preference.
     */
    public final TopicFilter topicFilter() {
        return topicFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filteredStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topicFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsFilter)) {
            return false;
        }
        ListContactsFilter other = (ListContactsFilter) obj;
        return Objects.equals(filteredStatusAsString(), other.filteredStatusAsString())
                && Objects.equals(topicFilter(), other.topicFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactsFilter").add("FilteredStatus", filteredStatusAsString())
                .add("TopicFilter", topicFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilteredStatus":
            return Optional.ofNullable(clazz.cast(filteredStatusAsString()));
        case "TopicFilter":
            return Optional.ofNullable(clazz.cast(topicFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListContactsFilter, T> g) {
        return obj -> g.apply((ListContactsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListContactsFilter> {
        /**
         * <p>
         * The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
         * </p>
         * 
         * @param filteredStatus
         *        The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
         * @see SubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionStatus
         */
        Builder filteredStatus(String filteredStatus);

        /**
         * <p>
         * The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
         * </p>
         * 
         * @param filteredStatus
         *        The status by which you are filtering: <code>OPT_IN</code> or <code>OPT_OUT</code>.
         * @see SubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionStatus
         */
        Builder filteredStatus(SubscriptionStatus filteredStatus);

        /**
         * <p>
         * Used for filtering by a specific topic preference.
         * </p>
         * 
         * @param topicFilter
         *        Used for filtering by a specific topic preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicFilter(TopicFilter topicFilter);

        /**
         * <p>
         * Used for filtering by a specific topic preference.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicFilter.Builder} avoiding the need to
         * create one manually via {@link TopicFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #topicFilter(TopicFilter)}.
         * 
         * @param topicFilter
         *        a consumer that will call methods on {@link TopicFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicFilter(TopicFilter)
         */
        default Builder topicFilter(Consumer<TopicFilter.Builder> topicFilter) {
            return topicFilter(TopicFilter.builder().applyMutation(topicFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filteredStatus;

        private TopicFilter topicFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsFilter model) {
            filteredStatus(model.filteredStatus);
            topicFilter(model.topicFilter);
        }

        public final String getFilteredStatus() {
            return filteredStatus;
        }

        public final void setFilteredStatus(String filteredStatus) {
            this.filteredStatus = filteredStatus;
        }

        @Override
        public final Builder filteredStatus(String filteredStatus) {
            this.filteredStatus = filteredStatus;
            return this;
        }

        @Override
        public final Builder filteredStatus(SubscriptionStatus filteredStatus) {
            this.filteredStatus(filteredStatus == null ? null : filteredStatus.toString());
            return this;
        }

        public final TopicFilter.Builder getTopicFilter() {
            return topicFilter != null ? topicFilter.toBuilder() : null;
        }

        public final void setTopicFilter(TopicFilter.BuilderImpl topicFilter) {
            this.topicFilter = topicFilter != null ? topicFilter.build() : null;
        }

        @Override
        public final Builder topicFilter(TopicFilter topicFilter) {
            this.topicFilter = topicFilter;
            return this;
        }

        @Override
        public ListContactsFilter build() {
            return new ListContactsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
