/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactListsResponse extends SesV2Response implements
        ToCopyableBuilder<ListContactListsResponse.Builder, ListContactListsResponse> {
    private static final SdkField<List<ContactList>> CONTACT_LISTS_FIELD = SdkField
            .<List<ContactList>> builder(MarshallingType.LIST)
            .memberName("ContactLists")
            .getter(getter(ListContactListsResponse::contactLists))
            .setter(setter(Builder::contactLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactList> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactListsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LISTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ContactLists", CONTACT_LISTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<ContactList> contactLists;

    private final String nextToken;

    private ListContactListsResponse(BuilderImpl builder) {
        super(builder);
        this.contactLists = builder.contactLists;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactLists property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContactLists() {
        return contactLists != null && !(contactLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available contact lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactLists} method.
     * </p>
     * 
     * @return The available contact lists.
     */
    public final List<ContactList> contactLists() {
        return contactLists;
    }

    /**
     * <p>
     * A string token indicating that there might be additional contact lists available to be listed. Copy this token to
     * a subsequent call to <code>ListContactLists</code> with the same parameters to retrieve the next page of contact
     * lists.
     * </p>
     * 
     * @return A string token indicating that there might be additional contact lists available to be listed. Copy this
     *         token to a subsequent call to <code>ListContactLists</code> with the same parameters to retrieve the next
     *         page of contact lists.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContactLists() ? contactLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactListsResponse)) {
            return false;
        }
        ListContactListsResponse other = (ListContactListsResponse) obj;
        return hasContactLists() == other.hasContactLists() && Objects.equals(contactLists(), other.contactLists())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactListsResponse").add("ContactLists", hasContactLists() ? contactLists() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactLists":
            return Optional.ofNullable(clazz.cast(contactLists()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListContactListsResponse, T> g) {
        return obj -> g.apply((ListContactListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListContactListsResponse> {
        /**
         * <p>
         * The available contact lists.
         * </p>
         * 
         * @param contactLists
         *        The available contact lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactLists(Collection<ContactList> contactLists);

        /**
         * <p>
         * The available contact lists.
         * </p>
         * 
         * @param contactLists
         *        The available contact lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactLists(ContactList... contactLists);

        /**
         * <p>
         * The available contact lists.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.ContactList.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.ContactList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.ContactList.Builder#build()} is called immediately and its
         * result is passed to {@link #contactLists(List<ContactList>)}.
         * 
         * @param contactLists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.ContactList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactLists(java.util.Collection<ContactList>)
         */
        Builder contactLists(Consumer<ContactList.Builder>... contactLists);

        /**
         * <p>
         * A string token indicating that there might be additional contact lists available to be listed. Copy this
         * token to a subsequent call to <code>ListContactLists</code> with the same parameters to retrieve the next
         * page of contact lists.
         * </p>
         * 
         * @param nextToken
         *        A string token indicating that there might be additional contact lists available to be listed. Copy
         *        this token to a subsequent call to <code>ListContactLists</code> with the same parameters to retrieve
         *        the next page of contact lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<ContactList> contactLists = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactListsResponse model) {
            super(model);
            contactLists(model.contactLists);
            nextToken(model.nextToken);
        }

        public final List<ContactList.Builder> getContactLists() {
            List<ContactList.Builder> result = ListOfContactListsCopier.copyToBuilder(this.contactLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactLists(Collection<ContactList.BuilderImpl> contactLists) {
            this.contactLists = ListOfContactListsCopier.copyFromBuilder(contactLists);
        }

        @Override
        public final Builder contactLists(Collection<ContactList> contactLists) {
            this.contactLists = ListOfContactListsCopier.copy(contactLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactLists(ContactList... contactLists) {
            contactLists(Arrays.asList(contactLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactLists(Consumer<ContactList.Builder>... contactLists) {
            contactLists(Stream.of(contactLists).map(c -> ContactList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactListsResponse build() {
            return new ListContactListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
