/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The following element is returned by the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEmailTemplateResponse extends SesV2Response implements
        ToCopyableBuilder<GetEmailTemplateResponse.Builder, GetEmailTemplateResponse> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(GetEmailTemplateResponse::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<EmailTemplateContent> TEMPLATE_CONTENT_FIELD = SdkField
            .<EmailTemplateContent> builder(MarshallingType.SDK_POJO).memberName("TemplateContent")
            .getter(getter(GetEmailTemplateResponse::templateContent)).setter(setter(Builder::templateContent))
            .constructor(EmailTemplateContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TemplateName", TEMPLATE_NAME_FIELD);
                    put("TemplateContent", TEMPLATE_CONTENT_FIELD);
                }
            });

    private final String templateName;

    private final EmailTemplateContent templateContent;

    private GetEmailTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateContent = builder.templateContent;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The content of the email template, composed of a subject line, an HTML part, and a text-only part.
     * </p>
     * 
     * @return The content of the email template, composed of a subject line, an HTML part, and a text-only part.
     */
    public final EmailTemplateContent templateContent() {
        return templateContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEmailTemplateResponse)) {
            return false;
        }
        GetEmailTemplateResponse other = (GetEmailTemplateResponse) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(templateContent(), other.templateContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEmailTemplateResponse").add("TemplateName", templateName())
                .add("TemplateContent", templateContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateContent":
            return Optional.ofNullable(clazz.cast(templateContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEmailTemplateResponse, T> g) {
        return obj -> g.apply((GetEmailTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetEmailTemplateResponse> {
        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param templateName
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The content of the email template, composed of a subject line, an HTML part, and a text-only part.
         * </p>
         * 
         * @param templateContent
         *        The content of the email template, composed of a subject line, an HTML part, and a text-only part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateContent(EmailTemplateContent templateContent);

        /**
         * <p>
         * The content of the email template, composed of a subject line, an HTML part, and a text-only part.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailTemplateContent.Builder} avoiding
         * the need to create one manually via {@link EmailTemplateContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailTemplateContent.Builder#build()} is called immediately and
         * its result is passed to {@link #templateContent(EmailTemplateContent)}.
         * 
         * @param templateContent
         *        a consumer that will call methods on {@link EmailTemplateContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateContent(EmailTemplateContent)
         */
        default Builder templateContent(Consumer<EmailTemplateContent.Builder> templateContent) {
            return templateContent(EmailTemplateContent.builder().applyMutation(templateContent).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String templateName;

        private EmailTemplateContent templateContent;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEmailTemplateResponse model) {
            super(model);
            templateName(model.templateName);
            templateContent(model.templateContent);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final EmailTemplateContent.Builder getTemplateContent() {
            return templateContent != null ? templateContent.toBuilder() : null;
        }

        public final void setTemplateContent(EmailTemplateContent.BuilderImpl templateContent) {
            this.templateContent = templateContent != null ? templateContent.build() : null;
        }

        @Override
        public final Builder templateContent(EmailTemplateContent templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        @Override
        public GetEmailTemplateResponse build() {
            return new GetEmailTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
