/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A contact is the end-user who is receiving the email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Contact implements SdkPojo, Serializable, ToCopyableBuilder<Contact.Builder, Contact> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(Contact::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<List<TopicPreference>> TOPIC_PREFERENCES_FIELD = SdkField
            .<List<TopicPreference>> builder(MarshallingType.LIST)
            .memberName("TopicPreferences")
            .getter(getter(Contact::topicPreferences))
            .setter(setter(Builder::topicPreferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicPreferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicPreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicPreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TopicPreference>> TOPIC_DEFAULT_PREFERENCES_FIELD = SdkField
            .<List<TopicPreference>> builder(MarshallingType.LIST)
            .memberName("TopicDefaultPreferences")
            .getter(getter(Contact::topicDefaultPreferences))
            .setter(setter(Builder::topicDefaultPreferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicDefaultPreferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicPreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicPreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> UNSUBSCRIBE_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UnsubscribeAll").getter(getter(Contact::unsubscribeAll)).setter(setter(Builder::unsubscribeAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsubscribeAll").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(Contact::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD,
            TOPIC_PREFERENCES_FIELD, TOPIC_DEFAULT_PREFERENCES_FIELD, UNSUBSCRIBE_ALL_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EmailAddress", EMAIL_ADDRESS_FIELD);
                    put("TopicPreferences", TOPIC_PREFERENCES_FIELD);
                    put("TopicDefaultPreferences", TOPIC_DEFAULT_PREFERENCES_FIELD);
                    put("UnsubscribeAll", UNSUBSCRIBE_ALL_FIELD);
                    put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String emailAddress;

    private final List<TopicPreference> topicPreferences;

    private final List<TopicPreference> topicDefaultPreferences;

    private final Boolean unsubscribeAll;

    private final Instant lastUpdatedTimestamp;

    private Contact(BuilderImpl builder) {
        this.emailAddress = builder.emailAddress;
        this.topicPreferences = builder.topicPreferences;
        this.topicDefaultPreferences = builder.topicDefaultPreferences;
        this.unsubscribeAll = builder.unsubscribeAll;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The contact's email address.
     * </p>
     * 
     * @return The contact's email address.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicPreferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopicPreferences() {
        return topicPreferences != null && !(topicPreferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contact's preference for being opted-in to or opted-out of a topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicPreferences} method.
     * </p>
     * 
     * @return The contact's preference for being opted-in to or opted-out of a topic.
     */
    public final List<TopicPreference> topicPreferences() {
        return topicPreferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicDefaultPreferences property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTopicDefaultPreferences() {
        return topicDefaultPreferences != null && !(topicDefaultPreferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default topic preferences applied to the contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicDefaultPreferences} method.
     * </p>
     * 
     * @return The default topic preferences applied to the contact.
     */
    public final List<TopicPreference> topicDefaultPreferences() {
        return topicDefaultPreferences;
    }

    /**
     * <p>
     * A boolean value status noting if the contact is unsubscribed from all contact list topics.
     * </p>
     * 
     * @return A boolean value status noting if the contact is unsubscribed from all contact list topics.
     */
    public final Boolean unsubscribeAll() {
        return unsubscribeAll;
    }

    /**
     * <p>
     * A timestamp noting the last time the contact's information was updated.
     * </p>
     * 
     * @return A timestamp noting the last time the contact's information was updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicPreferences() ? topicPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicDefaultPreferences() ? topicDefaultPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unsubscribeAll());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact other = (Contact) obj;
        return Objects.equals(emailAddress(), other.emailAddress()) && hasTopicPreferences() == other.hasTopicPreferences()
                && Objects.equals(topicPreferences(), other.topicPreferences())
                && hasTopicDefaultPreferences() == other.hasTopicDefaultPreferences()
                && Objects.equals(topicDefaultPreferences(), other.topicDefaultPreferences())
                && Objects.equals(unsubscribeAll(), other.unsubscribeAll())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Contact").add("EmailAddress", emailAddress())
                .add("TopicPreferences", hasTopicPreferences() ? topicPreferences() : null)
                .add("TopicDefaultPreferences", hasTopicDefaultPreferences() ? topicDefaultPreferences() : null)
                .add("UnsubscribeAll", unsubscribeAll()).add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "TopicPreferences":
            return Optional.ofNullable(clazz.cast(topicPreferences()));
        case "TopicDefaultPreferences":
            return Optional.ofNullable(clazz.cast(topicDefaultPreferences()));
        case "UnsubscribeAll":
            return Optional.ofNullable(clazz.cast(unsubscribeAll()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Contact, T> g) {
        return obj -> g.apply((Contact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Contact> {
        /**
         * <p>
         * The contact's email address.
         * </p>
         * 
         * @param emailAddress
         *        The contact's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The contact's preference for being opted-in to or opted-out of a topic.
         * </p>
         * 
         * @param topicPreferences
         *        The contact's preference for being opted-in to or opted-out of a topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPreferences(Collection<TopicPreference> topicPreferences);

        /**
         * <p>
         * The contact's preference for being opted-in to or opted-out of a topic.
         * </p>
         * 
         * @param topicPreferences
         *        The contact's preference for being opted-in to or opted-out of a topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPreferences(TopicPreference... topicPreferences);

        /**
         * <p>
         * The contact's preference for being opted-in to or opted-out of a topic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.TopicPreference.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.TopicPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.TopicPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #topicPreferences(List<TopicPreference>)}.
         * 
         * @param topicPreferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.TopicPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicPreferences(java.util.Collection<TopicPreference>)
         */
        Builder topicPreferences(Consumer<TopicPreference.Builder>... topicPreferences);

        /**
         * <p>
         * The default topic preferences applied to the contact.
         * </p>
         * 
         * @param topicDefaultPreferences
         *        The default topic preferences applied to the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicDefaultPreferences(Collection<TopicPreference> topicDefaultPreferences);

        /**
         * <p>
         * The default topic preferences applied to the contact.
         * </p>
         * 
         * @param topicDefaultPreferences
         *        The default topic preferences applied to the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicDefaultPreferences(TopicPreference... topicDefaultPreferences);

        /**
         * <p>
         * The default topic preferences applied to the contact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sesv2.model.TopicPreference.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sesv2.model.TopicPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sesv2.model.TopicPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #topicDefaultPreferences(List<TopicPreference>)}.
         * 
         * @param topicDefaultPreferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sesv2.model.TopicPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicDefaultPreferences(java.util.Collection<TopicPreference>)
         */
        Builder topicDefaultPreferences(Consumer<TopicPreference.Builder>... topicDefaultPreferences);

        /**
         * <p>
         * A boolean value status noting if the contact is unsubscribed from all contact list topics.
         * </p>
         * 
         * @param unsubscribeAll
         *        A boolean value status noting if the contact is unsubscribed from all contact list topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsubscribeAll(Boolean unsubscribeAll);

        /**
         * <p>
         * A timestamp noting the last time the contact's information was updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        A timestamp noting the last time the contact's information was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String emailAddress;

        private List<TopicPreference> topicPreferences = DefaultSdkAutoConstructList.getInstance();

        private List<TopicPreference> topicDefaultPreferences = DefaultSdkAutoConstructList.getInstance();

        private Boolean unsubscribeAll;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Contact model) {
            emailAddress(model.emailAddress);
            topicPreferences(model.topicPreferences);
            topicDefaultPreferences(model.topicDefaultPreferences);
            unsubscribeAll(model.unsubscribeAll);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final List<TopicPreference.Builder> getTopicPreferences() {
            List<TopicPreference.Builder> result = TopicPreferenceListCopier.copyToBuilder(this.topicPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicPreferences(Collection<TopicPreference.BuilderImpl> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copyFromBuilder(topicPreferences);
        }

        @Override
        public final Builder topicPreferences(Collection<TopicPreference> topicPreferences) {
            this.topicPreferences = TopicPreferenceListCopier.copy(topicPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicPreferences(TopicPreference... topicPreferences) {
            topicPreferences(Arrays.asList(topicPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicPreferences(Consumer<TopicPreference.Builder>... topicPreferences) {
            topicPreferences(Stream.of(topicPreferences).map(c -> TopicPreference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TopicPreference.Builder> getTopicDefaultPreferences() {
            List<TopicPreference.Builder> result = TopicPreferenceListCopier.copyToBuilder(this.topicDefaultPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicDefaultPreferences(Collection<TopicPreference.BuilderImpl> topicDefaultPreferences) {
            this.topicDefaultPreferences = TopicPreferenceListCopier.copyFromBuilder(topicDefaultPreferences);
        }

        @Override
        public final Builder topicDefaultPreferences(Collection<TopicPreference> topicDefaultPreferences) {
            this.topicDefaultPreferences = TopicPreferenceListCopier.copy(topicDefaultPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicDefaultPreferences(TopicPreference... topicDefaultPreferences) {
            topicDefaultPreferences(Arrays.asList(topicDefaultPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicDefaultPreferences(Consumer<TopicPreference.Builder>... topicDefaultPreferences) {
            topicDefaultPreferences(Stream.of(topicDefaultPreferences)
                    .map(c -> TopicPreference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUnsubscribeAll() {
            return unsubscribeAll;
        }

        public final void setUnsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
        }

        @Override
        public final Builder unsubscribeAll(Boolean unsubscribeAll) {
            this.unsubscribeAll = unsubscribeAll;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public Contact build() {
            return new Contact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
