/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ImportDataSource;
import software.amazon.awssdk.services.sesv2.model.ImportDestination;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImportJobRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, CreateImportJobRequest> {
    private static final SdkField<ImportDestination> IMPORT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportDestination").getter(CreateImportJobRequest.getter(CreateImportJobRequest::importDestination)).setter(CreateImportJobRequest.setter(Builder::importDestination)).constructor(ImportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDestination").build()}).build();
    private static final SdkField<ImportDataSource> IMPORT_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportDataSource").getter(CreateImportJobRequest.getter(CreateImportJobRequest::importDataSource)).setter(CreateImportJobRequest.setter(Builder::importDataSource)).constructor(ImportDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_DESTINATION_FIELD, IMPORT_DATA_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ImportDestination", IMPORT_DESTINATION_FIELD);
            this.put("ImportDataSource", IMPORT_DATA_SOURCE_FIELD);
        }
    });
    private final ImportDestination importDestination;
    private final ImportDataSource importDataSource;

    private CreateImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.importDestination = builder.importDestination;
        this.importDataSource = builder.importDataSource;
    }

    public final ImportDestination importDestination() {
        return this.importDestination;
    }

    public final ImportDataSource importDataSource() {
        return this.importDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImportJobRequest)) {
            return false;
        }
        CreateImportJobRequest other = (CreateImportJobRequest)((Object)obj);
        return Objects.equals(this.importDestination(), other.importDestination()) && Objects.equals(this.importDataSource(), other.importDataSource());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImportJobRequest").add("ImportDestination", (Object)this.importDestination()).add("ImportDataSource", (Object)this.importDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportDestination": {
                return Optional.ofNullable(clazz.cast(this.importDestination()));
            }
            case "ImportDataSource": {
                return Optional.ofNullable(clazz.cast(this.importDataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateImportJobRequest, T> g) {
        return obj -> g.apply((CreateImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private ImportDestination importDestination;
        private ImportDataSource importDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImportJobRequest model) {
            super(model);
            this.importDestination(model.importDestination);
            this.importDataSource(model.importDataSource);
        }

        public final ImportDestination.Builder getImportDestination() {
            return this.importDestination != null ? this.importDestination.toBuilder() : null;
        }

        public final void setImportDestination(ImportDestination.BuilderImpl importDestination) {
            this.importDestination = importDestination != null ? importDestination.build() : null;
        }

        @Override
        public final Builder importDestination(ImportDestination importDestination) {
            this.importDestination = importDestination;
            return this;
        }

        public final ImportDataSource.Builder getImportDataSource() {
            return this.importDataSource != null ? this.importDataSource.toBuilder() : null;
        }

        public final void setImportDataSource(ImportDataSource.BuilderImpl importDataSource) {
            this.importDataSource = importDataSource != null ? importDataSource.build() : null;
        }

        @Override
        public final Builder importDataSource(ImportDataSource importDataSource) {
            this.importDataSource = importDataSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImportJobRequest build() {
            return new CreateImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImportJobRequest> {
        public Builder importDestination(ImportDestination var1);

        default public Builder importDestination(Consumer<ImportDestination.Builder> importDestination) {
            return this.importDestination((ImportDestination)((ImportDestination.Builder)ImportDestination.builder().applyMutation(importDestination)).build());
        }

        public Builder importDataSource(ImportDataSource var1);

        default public Builder importDataSource(Consumer<ImportDataSource.Builder> importDataSource) {
            return this.importDataSource((ImportDataSource)((ImportDataSource.Builder)ImportDataSource.builder().applyMutation(importDataSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

