/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.VdmOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigurationSetVdmOptionsRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, PutConfigurationSetVdmOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(PutConfigurationSetVdmOptionsRequest.getter(PutConfigurationSetVdmOptionsRequest::configurationSetName)).setter(PutConfigurationSetVdmOptionsRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<VdmOptions> VDM_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VdmOptions").getter(PutConfigurationSetVdmOptionsRequest.getter(PutConfigurationSetVdmOptionsRequest::vdmOptions)).setter(PutConfigurationSetVdmOptionsRequest.setter(Builder::vdmOptions)).constructor(VdmOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VdmOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, VDM_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
            this.put("VdmOptions", VDM_OPTIONS_FIELD);
        }
    });
    private final String configurationSetName;
    private final VdmOptions vdmOptions;

    private PutConfigurationSetVdmOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.vdmOptions = builder.vdmOptions;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final VdmOptions vdmOptions() {
        return this.vdmOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vdmOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetVdmOptionsRequest)) {
            return false;
        }
        PutConfigurationSetVdmOptionsRequest other = (PutConfigurationSetVdmOptionsRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.vdmOptions(), other.vdmOptions());
    }

    public final String toString() {
        return ToString.builder((String)"PutConfigurationSetVdmOptionsRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("VdmOptions", (Object)this.vdmOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "VdmOptions": {
                return Optional.ofNullable(clazz.cast(this.vdmOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetVdmOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetVdmOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private VdmOptions vdmOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetVdmOptionsRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.vdmOptions(model.vdmOptions);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final VdmOptions.Builder getVdmOptions() {
            return this.vdmOptions != null ? this.vdmOptions.toBuilder() : null;
        }

        public final void setVdmOptions(VdmOptions.BuilderImpl vdmOptions) {
            this.vdmOptions = vdmOptions != null ? vdmOptions.build() : null;
        }

        @Override
        public final Builder vdmOptions(VdmOptions vdmOptions) {
            this.vdmOptions = vdmOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetVdmOptionsRequest build() {
            return new PutConfigurationSetVdmOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigurationSetVdmOptionsRequest> {
        public Builder configurationSetName(String var1);

        public Builder vdmOptions(VdmOptions var1);

        default public Builder vdmOptions(Consumer<VdmOptions.Builder> vdmOptions) {
            return this.vdmOptions((VdmOptions)((VdmOptions.Builder)VdmOptions.builder().applyMutation(vdmOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

