/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sesv2.DefaultSesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.DefaultSesV2BaseClientBuilder;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClientBuilder;
import software.amazon.awssdk.services.sesv2.SesV2ServiceClientConfiguration;
import software.amazon.awssdk.services.sesv2.endpoints.SesV2EndpointProvider;

@SdkInternalApi
final class DefaultSesV2AsyncClientBuilder
extends DefaultSesV2BaseClientBuilder<SesV2AsyncClientBuilder, SesV2AsyncClient>
implements SesV2AsyncClientBuilder {
    DefaultSesV2AsyncClientBuilder() {
    }

    @Override
    public DefaultSesV2AsyncClientBuilder endpointProvider(SesV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SesV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSesV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        SesV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSesV2AsyncClient client = new DefaultSesV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SesV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SesV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

