/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReason;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigurationSetSuppressionOptionsRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, PutConfigurationSetSuppressionOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(PutConfigurationSetSuppressionOptionsRequest.getter(PutConfigurationSetSuppressionOptionsRequest::configurationSetName)).setter(PutConfigurationSetSuppressionOptionsRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<List<String>> SUPPRESSED_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuppressedReasons").getter(PutConfigurationSetSuppressionOptionsRequest.getter(PutConfigurationSetSuppressionOptionsRequest::suppressedReasonsAsStrings)).setter(PutConfigurationSetSuppressionOptionsRequest.setter(Builder::suppressedReasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD, SUPPRESSED_REASONS_FIELD));
    private final String configurationSetName;
    private final List<String> suppressedReasons;

    private PutConfigurationSetSuppressionOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.suppressedReasons = builder.suppressedReasons;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public List<SuppressionListReason> suppressedReasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(this.suppressedReasons);
    }

    public boolean hasSuppressedReasons() {
        return this.suppressedReasons != null && !(this.suppressedReasons instanceof SdkAutoConstructList);
    }

    public List<String> suppressedReasonsAsStrings() {
        return this.suppressedReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressedReasonsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetSuppressionOptionsRequest)) {
            return false;
        }
        PutConfigurationSetSuppressionOptionsRequest other = (PutConfigurationSetSuppressionOptionsRequest)((Object)obj);
        return Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.suppressedReasonsAsStrings(), other.suppressedReasonsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"PutConfigurationSetSuppressionOptionsRequest").add("ConfigurationSetName", (Object)this.configurationSetName()).add("SuppressedReasons", this.suppressedReasonsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "SuppressedReasons": {
                return Optional.ofNullable(clazz.cast(this.suppressedReasonsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetSuppressionOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetSuppressionOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String configurationSetName;
        private List<String> suppressedReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetSuppressionOptionsRequest model) {
            super(model);
            this.configurationSetName(model.configurationSetName);
            this.suppressedReasonsWithStrings(model.suppressedReasons);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Collection<String> getSuppressedReasons() {
            return this.suppressedReasons;
        }

        @Override
        public final Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasonsWithStrings(String ... suppressedReasons) {
            this.suppressedReasonsWithStrings(Arrays.asList(suppressedReasons));
            return this;
        }

        @Override
        public final Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copyEnumToString(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasons(SuppressionListReason ... suppressedReasons) {
            this.suppressedReasons(Arrays.asList(suppressedReasons));
            return this;
        }

        public final void setSuppressedReasons(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetSuppressionOptionsRequest build() {
            return new PutConfigurationSetSuppressionOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigurationSetSuppressionOptionsRequest> {
        public Builder configurationSetName(String var1);

        public Builder suppressedReasonsWithStrings(Collection<String> var1);

        public Builder suppressedReasonsWithStrings(String ... var1);

        public Builder suppressedReasons(Collection<SuppressionListReason> var1);

        public Builder suppressedReasons(SuppressionListReason ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

