/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.IdentityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityInfo> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IdentityInfo.getter(IdentityInfo::identityTypeAsString)).setter(IdentityInfo.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final SdkField<String> IDENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IdentityInfo.getter(IdentityInfo::identityName)).setter(IdentityInfo.setter(Builder::identityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityName").build()}).build();
    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(IdentityInfo.getter(IdentityInfo::sendingEnabled)).setter(IdentityInfo.setter(Builder::sendingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD, IDENTITY_NAME_FIELD, SENDING_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identityType;
    private final String identityName;
    private final Boolean sendingEnabled;

    private IdentityInfo(BuilderImpl builder) {
        this.identityType = builder.identityType;
        this.identityName = builder.identityName;
        this.sendingEnabled = builder.sendingEnabled;
    }

    public IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public String identityTypeAsString() {
        return this.identityType;
    }

    public String identityName() {
        return this.identityName;
    }

    public Boolean sendingEnabled() {
        return this.sendingEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityInfo)) {
            return false;
        }
        IdentityInfo other = (IdentityInfo)obj;
        return Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.identityName(), other.identityName()) && Objects.equals(this.sendingEnabled(), other.sendingEnabled());
    }

    public String toString() {
        return ToString.builder((String)"IdentityInfo").add("IdentityType", (Object)this.identityTypeAsString()).add("IdentityName", (Object)this.identityName()).add("SendingEnabled", (Object)this.sendingEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "IdentityName": {
                return Optional.ofNullable(clazz.cast(this.identityName()));
            }
            case "SendingEnabled": {
                return Optional.ofNullable(clazz.cast(this.sendingEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityInfo, T> g) {
        return obj -> g.apply((IdentityInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityType;
        private String identityName;
        private Boolean sendingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityInfo model) {
            this.identityType(model.identityType);
            this.identityName(model.identityName);
            this.sendingEnabled(model.sendingEnabled);
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final String getIdentityName() {
            return this.identityName;
        }

        @Override
        public final Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public final void setIdentityName(String identityName) {
            this.identityName = identityName;
        }

        public final Boolean getSendingEnabled() {
            return this.sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        public IdentityInfo build() {
            return new IdentityInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityInfo> {
        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder identityName(String var1);

        public Builder sendingEnabled(Boolean var1);
    }
}

