/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.model.AccountSendingPausedException;
import software.amazon.awssdk.services.ses.model.AlreadyExistsException;
import software.amazon.awssdk.services.ses.model.CannotDeleteException;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.ConfigurationSetAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.ConfigurationSetDoesNotExistException;
import software.amazon.awssdk.services.ses.model.ConfigurationSetSendingPausedException;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.CreateTemplateRequest;
import software.amazon.awssdk.services.ses.model.CreateTemplateResponse;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailInvalidContentException;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplateAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplateDoesNotExistException;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.DeleteIdentityRequest;
import software.amazon.awssdk.services.ses.model.DeleteIdentityResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptFilterResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.ses.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeConfigurationSetResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.EventDestinationAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.EventDestinationDoesNotExistException;
import software.amazon.awssdk.services.ses.model.FromEmailAddressNotVerifiedException;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.GetSendQuotaRequest;
import software.amazon.awssdk.services.ses.model.GetSendQuotaResponse;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsRequest;
import software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse;
import software.amazon.awssdk.services.ses.model.GetTemplateRequest;
import software.amazon.awssdk.services.ses.model.GetTemplateResponse;
import software.amazon.awssdk.services.ses.model.InvalidCloudWatchDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidConfigurationSetException;
import software.amazon.awssdk.services.ses.model.InvalidFirehoseDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidLambdaFunctionException;
import software.amazon.awssdk.services.ses.model.InvalidPolicyException;
import software.amazon.awssdk.services.ses.model.InvalidRenderingParameterException;
import software.amazon.awssdk.services.ses.model.InvalidS3ConfigurationException;
import software.amazon.awssdk.services.ses.model.InvalidSnsDestinationException;
import software.amazon.awssdk.services.ses.model.InvalidSnsTopicException;
import software.amazon.awssdk.services.ses.model.InvalidTemplateException;
import software.amazon.awssdk.services.ses.model.InvalidTrackingOptionsException;
import software.amazon.awssdk.services.ses.model.LimitExceededException;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentityPoliciesResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptFiltersResponse;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest;
import software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse;
import software.amazon.awssdk.services.ses.model.ListTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListTemplatesResponse;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesRequest;
import software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse;
import software.amazon.awssdk.services.ses.model.MailFromDomainNotVerifiedException;
import software.amazon.awssdk.services.ses.model.MessageRejectedException;
import software.amazon.awssdk.services.ses.model.MissingRenderingAttributeException;
import software.amazon.awssdk.services.ses.model.ProductionAccessNotGrantedException;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyResponse;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.RuleDoesNotExistException;
import software.amazon.awssdk.services.ses.model.RuleSetDoesNotExistException;
import software.amazon.awssdk.services.ses.model.SendBounceRequest;
import software.amazon.awssdk.services.ses.model.SendBounceResponse;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendEmailResponse;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.services.ses.model.SendRawEmailResponse;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest;
import software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse;
import software.amazon.awssdk.services.ses.model.SesException;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest;
import software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainResponse;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest;
import software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicResponse;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest;
import software.amazon.awssdk.services.ses.model.SetReceiptRulePositionResponse;
import software.amazon.awssdk.services.ses.model.TemplateDoesNotExistException;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest;
import software.amazon.awssdk.services.ses.model.TestRenderTemplateResponse;
import software.amazon.awssdk.services.ses.model.TrackingOptionsAlreadyExistsException;
import software.amazon.awssdk.services.ses.model.TrackingOptionsDoesNotExistException;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledResponse;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateResponse;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.UpdateReceiptRuleResponse;
import software.amazon.awssdk.services.ses.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.ses.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressResponse;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailIdentityResponse;
import software.amazon.awssdk.services.ses.paginators.ListCustomVerificationEmailTemplatesIterable;
import software.amazon.awssdk.services.ses.paginators.ListIdentitiesIterable;
import software.amazon.awssdk.services.ses.transform.CloneReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateReceiptFilterRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.CreateTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteIdentityRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteReceiptFilterRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DeleteVerifiedEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeActiveReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.DescribeReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetAccountSendingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityDkimAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityMailFromDomainAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityPoliciesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetIdentityVerificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetSendQuotaRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetSendStatisticsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListCustomVerificationEmailTemplatesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListIdentityPoliciesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListReceiptFiltersRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListReceiptRuleSetsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ListVerifiedEmailAddressesRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.PutIdentityPolicyRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.ReorderReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendBounceRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendBulkTemplatedEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendCustomVerificationEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendRawEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SendTemplatedEmailRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetActiveReceiptRuleSetRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityDkimEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityFeedbackForwardingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityHeadersInNotificationsEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityMailFromDomainRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetIdentityNotificationTopicRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.SetReceiptRulePositionRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.TestRenderTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateAccountSendingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetReputationMetricsEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetSendingEnabledRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateConfigurationSetTrackingOptionsRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateCustomVerificationEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateReceiptRuleRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.UpdateTemplateRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyDomainDkimRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyDomainIdentityRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.ses.transform.VerifyEmailIdentityRequestMarshaller;

@SdkInternalApi
final class DefaultSesClient
implements SesClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "ses";
    }

    @Override
    public CloneReceiptRuleSetResponse cloneReceiptRuleSet(CloneReceiptRuleSetRequest cloneReceiptRuleSetRequest) throws RuleSetDoesNotExistException, AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CloneReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CloneReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CloneReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cloneReceiptRuleSetRequest).withMarshaller((Marshaller)new CloneReceiptRuleSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest) throws ConfigurationSetAlreadyExistsException, InvalidConfigurationSetException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetRequest).withMarshaller((Marshaller)new CreateConfigurationSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) throws ConfigurationSetDoesNotExistException, EventDestinationAlreadyExistsException, InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new CreateConfigurationSetEventDestinationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateConfigurationSetTrackingOptionsResponse createConfigurationSetTrackingOptions(CreateConfigurationSetTrackingOptionsRequest createConfigurationSetTrackingOptionsRequest) throws ConfigurationSetDoesNotExistException, TrackingOptionsAlreadyExistsException, InvalidTrackingOptionsException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationSetTrackingOptionsRequest).withMarshaller((Marshaller)new CreateConfigurationSetTrackingOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCustomVerificationEmailTemplateResponse createCustomVerificationEmailTemplate(CreateCustomVerificationEmailTemplateRequest createCustomVerificationEmailTemplateRequest) throws CustomVerificationEmailTemplateAlreadyExistsException, FromEmailAddressNotVerifiedException, CustomVerificationEmailInvalidContentException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomVerificationEmailTemplateRequest).withMarshaller((Marshaller)new CreateCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateReceiptFilterResponse createReceiptFilter(CreateReceiptFilterRequest createReceiptFilterRequest) throws LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReceiptFilterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateReceiptFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReceiptFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReceiptFilterRequest).withMarshaller((Marshaller)new CreateReceiptFilterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateReceiptRuleResponse createReceiptRule(CreateReceiptRuleRequest createReceiptRuleRequest) throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException, AlreadyExistsException, RuleDoesNotExistException, RuleSetDoesNotExistException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReceiptRuleRequest).withMarshaller((Marshaller)new CreateReceiptRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateReceiptRuleSetResponse createReceiptRuleSet(CreateReceiptRuleSetRequest createReceiptRuleSetRequest) throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReceiptRuleSetRequest).withMarshaller((Marshaller)new CreateReceiptRuleSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest) throws AlreadyExistsException, InvalidTemplateException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTemplateRequest).withMarshaller((Marshaller)new CreateTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetRequest).withMarshaller((Marshaller)new DeleteConfigurationSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new DeleteConfigurationSetEventDestinationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationSetTrackingOptionsResponse deleteConfigurationSetTrackingOptions(DeleteConfigurationSetTrackingOptionsRequest deleteConfigurationSetTrackingOptionsRequest) throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationSetTrackingOptionsRequest).withMarshaller((Marshaller)new DeleteConfigurationSetTrackingOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCustomVerificationEmailTemplateResponse deleteCustomVerificationEmailTemplate(DeleteCustomVerificationEmailTemplateRequest deleteCustomVerificationEmailTemplateRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomVerificationEmailTemplateRequest).withMarshaller((Marshaller)new DeleteCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteIdentityResponse deleteIdentity(DeleteIdentityRequest deleteIdentityRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentityRequest).withMarshaller((Marshaller)new DeleteIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteIdentityPolicyResponse deleteIdentityPolicy(DeleteIdentityPolicyRequest deleteIdentityPolicyRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteIdentityPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteIdentityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentityPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentityPolicyRequest).withMarshaller((Marshaller)new DeleteIdentityPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteReceiptFilterResponse deleteReceiptFilter(DeleteReceiptFilterRequest deleteReceiptFilterRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReceiptFilterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteReceiptFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReceiptFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReceiptFilterRequest).withMarshaller((Marshaller)new DeleteReceiptFilterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteReceiptRuleResponse deleteReceiptRule(DeleteReceiptRuleRequest deleteReceiptRuleRequest) throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReceiptRuleRequest).withMarshaller((Marshaller)new DeleteReceiptRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteReceiptRuleSetResponse deleteReceiptRuleSet(DeleteReceiptRuleSetRequest deleteReceiptRuleSetRequest) throws CannotDeleteException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReceiptRuleSetRequest).withMarshaller((Marshaller)new DeleteReceiptRuleSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTemplateRequest).withMarshaller((Marshaller)new DeleteTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteVerifiedEmailAddressResponse deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteVerifiedEmailAddressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteVerifiedEmailAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVerifiedEmailAddress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVerifiedEmailAddressRequest).withMarshaller((Marshaller)new DeleteVerifiedEmailAddressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeActiveReceiptRuleSetResponse describeActiveReceiptRuleSet(DescribeActiveReceiptRuleSetRequest describeActiveReceiptRuleSetRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeActiveReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeActiveReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActiveReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeActiveReceiptRuleSetRequest).withMarshaller((Marshaller)new DescribeActiveReceiptRuleSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationSetResponse describeConfigurationSet(DescribeConfigurationSetRequest describeConfigurationSetRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeConfigurationSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeConfigurationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationSetRequest).withMarshaller((Marshaller)new DescribeConfigurationSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeReceiptRuleResponse describeReceiptRule(DescribeReceiptRuleRequest describeReceiptRuleRequest) throws RuleDoesNotExistException, RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReceiptRuleRequest).withMarshaller((Marshaller)new DescribeReceiptRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeReceiptRuleSetResponse describeReceiptRuleSet(DescribeReceiptRuleSetRequest describeReceiptRuleSetRequest) throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReceiptRuleSetRequest).withMarshaller((Marshaller)new DescribeReceiptRuleSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAccountSendingEnabledResponse getAccountSendingEnabled(GetAccountSendingEnabledRequest getAccountSendingEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetAccountSendingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetAccountSendingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountSendingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountSendingEnabledRequest).withMarshaller((Marshaller)new GetAccountSendingEnabledRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCustomVerificationEmailTemplateResponse getCustomVerificationEmailTemplate(GetCustomVerificationEmailTemplateRequest getCustomVerificationEmailTemplateRequest) throws CustomVerificationEmailTemplateDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCustomVerificationEmailTemplateRequest).withMarshaller((Marshaller)new GetCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIdentityDkimAttributesResponse getIdentityDkimAttributes(GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityDkimAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetIdentityDkimAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityDkimAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityDkimAttributesRequest).withMarshaller((Marshaller)new GetIdentityDkimAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIdentityMailFromDomainAttributesResponse getIdentityMailFromDomainAttributes(GetIdentityMailFromDomainAttributesRequest getIdentityMailFromDomainAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityMailFromDomainAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetIdentityMailFromDomainAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityMailFromDomainAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityMailFromDomainAttributesRequest).withMarshaller((Marshaller)new GetIdentityMailFromDomainAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIdentityNotificationAttributesResponse getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityNotificationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetIdentityNotificationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityNotificationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityNotificationAttributesRequest).withMarshaller((Marshaller)new GetIdentityNotificationAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIdentityPoliciesResponse getIdentityPolicies(GetIdentityPoliciesRequest getIdentityPoliciesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetIdentityPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityPoliciesRequest).withMarshaller((Marshaller)new GetIdentityPoliciesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIdentityVerificationAttributesResponse getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetIdentityVerificationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetIdentityVerificationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityVerificationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityVerificationAttributesRequest).withMarshaller((Marshaller)new GetIdentityVerificationAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSendQuotaResponse getSendQuota(GetSendQuotaRequest getSendQuotaRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSendQuotaResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetSendQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSendQuota").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSendQuotaRequest).withMarshaller((Marshaller)new GetSendQuotaRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSendStatisticsResponse getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSendStatisticsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetSendStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSendStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSendStatisticsRequest).withMarshaller((Marshaller)new GetSendStatisticsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws TemplateDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemplateRequest).withMarshaller((Marshaller)new GetTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListConfigurationSetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListConfigurationSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationSetsRequest).withMarshaller((Marshaller)new ListConfigurationSetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListCustomVerificationEmailTemplatesResponse listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListCustomVerificationEmailTemplatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListCustomVerificationEmailTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomVerificationEmailTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomVerificationEmailTemplatesRequest).withMarshaller((Marshaller)new ListCustomVerificationEmailTemplatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListCustomVerificationEmailTemplatesIterable listCustomVerificationEmailTemplatesPaginator(ListCustomVerificationEmailTemplatesRequest listCustomVerificationEmailTemplatesRequest) throws AwsServiceException, SdkClientException, SesException {
        return new ListCustomVerificationEmailTemplatesIterable(this, this.applyPaginatorUserAgent(listCustomVerificationEmailTemplatesRequest));
    }

    @Override
    public ListIdentitiesResponse listIdentities(ListIdentitiesRequest listIdentitiesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListIdentitiesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentitiesRequest).withMarshaller((Marshaller)new ListIdentitiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListIdentitiesIterable listIdentitiesPaginator(ListIdentitiesRequest listIdentitiesRequest) throws AwsServiceException, SdkClientException, SesException {
        return new ListIdentitiesIterable(this, this.applyPaginatorUserAgent(listIdentitiesRequest));
    }

    @Override
    public ListIdentityPoliciesResponse listIdentityPolicies(ListIdentityPoliciesRequest listIdentityPoliciesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListIdentityPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListIdentityPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentityPoliciesRequest).withMarshaller((Marshaller)new ListIdentityPoliciesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListReceiptFiltersResponse listReceiptFilters(ListReceiptFiltersRequest listReceiptFiltersRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListReceiptFiltersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListReceiptFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceiptFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceiptFiltersRequest).withMarshaller((Marshaller)new ListReceiptFiltersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListReceiptRuleSetsResponse listReceiptRuleSets(ListReceiptRuleSetsRequest listReceiptRuleSetsRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListReceiptRuleSetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListReceiptRuleSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReceiptRuleSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReceiptRuleSetsRequest).withMarshaller((Marshaller)new ListReceiptRuleSetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTemplatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTemplatesRequest).withMarshaller((Marshaller)new ListTemplatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListVerifiedEmailAddressesResponse listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListVerifiedEmailAddressesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListVerifiedEmailAddressesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVerifiedEmailAddresses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVerifiedEmailAddressesRequest).withMarshaller((Marshaller)new ListVerifiedEmailAddressesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutIdentityPolicyResponse putIdentityPolicy(PutIdentityPolicyRequest putIdentityPolicyRequest) throws InvalidPolicyException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutIdentityPolicyResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PutIdentityPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutIdentityPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putIdentityPolicyRequest).withMarshaller((Marshaller)new PutIdentityPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ReorderReceiptRuleSetResponse reorderReceiptRuleSet(ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest) throws RuleSetDoesNotExistException, RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ReorderReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ReorderReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReorderReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reorderReceiptRuleSetRequest).withMarshaller((Marshaller)new ReorderReceiptRuleSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendBounceResponse sendBounce(SendBounceRequest sendBounceRequest) throws MessageRejectedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendBounceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendBounceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendBounce").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendBounceRequest).withMarshaller((Marshaller)new SendBounceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendBulkTemplatedEmailResponse sendBulkTemplatedEmail(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, TemplateDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendBulkTemplatedEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendBulkTemplatedEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendBulkTemplatedEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendBulkTemplatedEmailRequest).withMarshaller((Marshaller)new SendBulkTemplatedEmailRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendCustomVerificationEmailResponse sendCustomVerificationEmail(SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) throws MessageRejectedException, ConfigurationSetDoesNotExistException, CustomVerificationEmailTemplateDoesNotExistException, FromEmailAddressNotVerifiedException, ProductionAccessNotGrantedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendCustomVerificationEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendCustomVerificationEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendCustomVerificationEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendCustomVerificationEmailRequest).withMarshaller((Marshaller)new SendCustomVerificationEmailRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendEmailRequest).withMarshaller((Marshaller)new SendEmailRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendRawEmailResponse sendRawEmail(SendRawEmailRequest sendRawEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendRawEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendRawEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendRawEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendRawEmailRequest).withMarshaller((Marshaller)new SendRawEmailRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendTemplatedEmailResponse sendTemplatedEmail(SendTemplatedEmailRequest sendTemplatedEmailRequest) throws MessageRejectedException, MailFromDomainNotVerifiedException, ConfigurationSetDoesNotExistException, TemplateDoesNotExistException, ConfigurationSetSendingPausedException, AccountSendingPausedException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SendTemplatedEmailResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SendTemplatedEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTemplatedEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendTemplatedEmailRequest).withMarshaller((Marshaller)new SendTemplatedEmailRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetActiveReceiptRuleSetResponse setActiveReceiptRuleSet(SetActiveReceiptRuleSetRequest setActiveReceiptRuleSetRequest) throws RuleSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetActiveReceiptRuleSetResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetActiveReceiptRuleSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetActiveReceiptRuleSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setActiveReceiptRuleSetRequest).withMarshaller((Marshaller)new SetActiveReceiptRuleSetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetIdentityDkimEnabledResponse setIdentityDkimEnabled(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityDkimEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetIdentityDkimEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityDkimEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityDkimEnabledRequest).withMarshaller((Marshaller)new SetIdentityDkimEnabledRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetIdentityFeedbackForwardingEnabledResponse setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityFeedbackForwardingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetIdentityFeedbackForwardingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityFeedbackForwardingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityFeedbackForwardingEnabledRequest).withMarshaller((Marshaller)new SetIdentityFeedbackForwardingEnabledRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetIdentityHeadersInNotificationsEnabledResponse setIdentityHeadersInNotificationsEnabled(SetIdentityHeadersInNotificationsEnabledRequest setIdentityHeadersInNotificationsEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityHeadersInNotificationsEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetIdentityHeadersInNotificationsEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityHeadersInNotificationsEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityHeadersInNotificationsEnabledRequest).withMarshaller((Marshaller)new SetIdentityHeadersInNotificationsEnabledRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetIdentityMailFromDomainResponse setIdentityMailFromDomain(SetIdentityMailFromDomainRequest setIdentityMailFromDomainRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityMailFromDomainResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetIdentityMailFromDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityMailFromDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityMailFromDomainRequest).withMarshaller((Marshaller)new SetIdentityMailFromDomainRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetIdentityNotificationTopicResponse setIdentityNotificationTopic(SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIdentityNotificationTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetIdentityNotificationTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityNotificationTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityNotificationTopicRequest).withMarshaller((Marshaller)new SetIdentityNotificationTopicRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetReceiptRulePositionResponse setReceiptRulePosition(SetReceiptRulePositionRequest setReceiptRulePositionRequest) throws RuleSetDoesNotExistException, RuleDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetReceiptRulePositionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetReceiptRulePositionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetReceiptRulePosition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setReceiptRulePositionRequest).withMarshaller((Marshaller)new SetReceiptRulePositionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TestRenderTemplateResponse testRenderTemplate(TestRenderTemplateRequest testRenderTemplateRequest) throws TemplateDoesNotExistException, InvalidRenderingParameterException, MissingRenderingAttributeException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TestRenderTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TestRenderTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestRenderTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testRenderTemplateRequest).withMarshaller((Marshaller)new TestRenderTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateAccountSendingEnabledResponse updateAccountSendingEnabled(UpdateAccountSendingEnabledRequest updateAccountSendingEnabledRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAccountSendingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateAccountSendingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountSendingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAccountSendingEnabledRequest).withMarshaller((Marshaller)new UpdateAccountSendingEnabledRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) throws ConfigurationSetDoesNotExistException, EventDestinationDoesNotExistException, InvalidCloudWatchDestinationException, InvalidFirehoseDestinationException, InvalidSnsDestinationException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetEventDestinationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateConfigurationSetEventDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetEventDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetEventDestinationRequest).withMarshaller((Marshaller)new UpdateConfigurationSetEventDestinationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationSetReputationMetricsEnabledResponse updateConfigurationSetReputationMetricsEnabled(UpdateConfigurationSetReputationMetricsEnabledRequest updateConfigurationSetReputationMetricsEnabledRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetReputationMetricsEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateConfigurationSetReputationMetricsEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetReputationMetricsEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetReputationMetricsEnabledRequest).withMarshaller((Marshaller)new UpdateConfigurationSetReputationMetricsEnabledRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationSetSendingEnabledResponse updateConfigurationSetSendingEnabled(UpdateConfigurationSetSendingEnabledRequest updateConfigurationSetSendingEnabledRequest) throws ConfigurationSetDoesNotExistException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetSendingEnabledResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateConfigurationSetSendingEnabledResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetSendingEnabled").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetSendingEnabledRequest).withMarshaller((Marshaller)new UpdateConfigurationSetSendingEnabledRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationSetTrackingOptionsResponse updateConfigurationSetTrackingOptions(UpdateConfigurationSetTrackingOptionsRequest updateConfigurationSetTrackingOptionsRequest) throws ConfigurationSetDoesNotExistException, TrackingOptionsDoesNotExistException, InvalidTrackingOptionsException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateConfigurationSetTrackingOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateConfigurationSetTrackingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfigurationSetTrackingOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationSetTrackingOptionsRequest).withMarshaller((Marshaller)new UpdateConfigurationSetTrackingOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateCustomVerificationEmailTemplateResponse updateCustomVerificationEmailTemplate(UpdateCustomVerificationEmailTemplateRequest updateCustomVerificationEmailTemplateRequest) throws CustomVerificationEmailTemplateDoesNotExistException, FromEmailAddressNotVerifiedException, CustomVerificationEmailInvalidContentException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateCustomVerificationEmailTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateCustomVerificationEmailTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomVerificationEmailTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCustomVerificationEmailTemplateRequest).withMarshaller((Marshaller)new UpdateCustomVerificationEmailTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateReceiptRuleResponse updateReceiptRule(UpdateReceiptRuleRequest updateReceiptRuleRequest) throws InvalidSnsTopicException, InvalidS3ConfigurationException, InvalidLambdaFunctionException, RuleSetDoesNotExistException, RuleDoesNotExistException, LimitExceededException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateReceiptRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateReceiptRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReceiptRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateReceiptRuleRequest).withMarshaller((Marshaller)new UpdateReceiptRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateTemplateResponse updateTemplate(UpdateTemplateRequest updateTemplateRequest) throws TemplateDoesNotExistException, InvalidTemplateException, AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateTemplateResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTemplateRequest).withMarshaller((Marshaller)new UpdateTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public VerifyDomainDkimResponse verifyDomainDkim(VerifyDomainDkimRequest verifyDomainDkimRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyDomainDkimResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (VerifyDomainDkimResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyDomainDkim").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyDomainDkimRequest).withMarshaller((Marshaller)new VerifyDomainDkimRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public VerifyDomainIdentityResponse verifyDomainIdentity(VerifyDomainIdentityRequest verifyDomainIdentityRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyDomainIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (VerifyDomainIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyDomainIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyDomainIdentityRequest).withMarshaller((Marshaller)new VerifyDomainIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public VerifyEmailAddressResponse verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyEmailAddressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (VerifyEmailAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyEmailAddress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyEmailAddressRequest).withMarshaller((Marshaller)new VerifyEmailAddressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public VerifyEmailIdentityResponse verifyEmailIdentity(VerifyEmailIdentityRequest verifyEmailIdentityRequest) throws AwsServiceException, SdkClientException, SesException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifyEmailIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (VerifyEmailIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyEmailIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyEmailIdentityRequest).withMarshaller((Marshaller)new VerifyEmailIdentityRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFirehoseDestination").exceptionBuilderSupplier(InvalidFirehoseDestinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3Configuration").exceptionBuilderSupplier(InvalidS3ConfigurationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRenderingParameter").exceptionBuilderSupplier(InvalidRenderingParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSNSDestination").exceptionBuilderSupplier(InvalidSnsDestinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MessageRejected").exceptionBuilderSupplier(MessageRejectedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCloudWatchDestination").exceptionBuilderSupplier(InvalidCloudWatchDestinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountSendingPausedException").exceptionBuilderSupplier(AccountSendingPausedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RuleSetDoesNotExist").exceptionBuilderSupplier(RuleSetDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnsTopic").exceptionBuilderSupplier(InvalidSnsTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConfigurationSetSendingPausedException").exceptionBuilderSupplier(ConfigurationSetSendingPausedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDestinationDoesNotExist").exceptionBuilderSupplier(EventDestinationDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLambdaFunction").exceptionBuilderSupplier(InvalidLambdaFunctionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TemplateDoesNotExist").exceptionBuilderSupplier(TemplateDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingRenderingAttribute").exceptionBuilderSupplier(MissingRenderingAttributeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExists").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotDelete").exceptionBuilderSupplier(CannotDeleteException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrackingOptionsAlreadyExistsException").exceptionBuilderSupplier(TrackingOptionsAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConfigurationSetAlreadyExists").exceptionBuilderSupplier(ConfigurationSetAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomVerificationEmailInvalidContent").exceptionBuilderSupplier(CustomVerificationEmailInvalidContentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTemplate").exceptionBuilderSupplier(InvalidTemplateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MailFromDomainNotVerifiedException").exceptionBuilderSupplier(MailFromDomainNotVerifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConfigurationSetDoesNotExist").exceptionBuilderSupplier(ConfigurationSetDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProductionAccessNotGranted").exceptionBuilderSupplier(ProductionAccessNotGrantedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTrackingOptions").exceptionBuilderSupplier(InvalidTrackingOptionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrackingOptionsDoesNotExistException").exceptionBuilderSupplier(TrackingOptionsDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventDestinationAlreadyExists").exceptionBuilderSupplier(EventDestinationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FromEmailAddressNotVerified").exceptionBuilderSupplier(FromEmailAddressNotVerifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RuleDoesNotExist").exceptionBuilderSupplier(RuleDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationSet").exceptionBuilderSupplier(InvalidConfigurationSetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomVerificationEmailTemplateDoesNotExist").exceptionBuilderSupplier(CustomVerificationEmailTemplateDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPolicy").exceptionBuilderSupplier(InvalidPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomVerificationEmailTemplateAlreadyExists").exceptionBuilderSupplier(CustomVerificationEmailTemplateAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SesException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SesRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.20").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SesRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

