/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SNSActionEncoding {
    UTF_8("UTF-8"),
    BASE64("Base64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SNSActionEncoding> VALUE_MAP;
    private final String value;

    private SNSActionEncoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SNSActionEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SNSActionEncoding> knownValues() {
        EnumSet<SNSActionEncoding> knownValues = EnumSet.allOf(SNSActionEncoding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SNSActionEncoding.class, SNSActionEncoding::toString);
    }
}

