/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectAction> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceARN").getter(ConnectAction.getter(ConnectAction::instanceARN)).setter(ConnectAction.setter(Builder::instanceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceARN").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IAMRoleARN").getter(ConnectAction.getter(ConnectAction::iamRoleARN)).setter(ConnectAction.setter(Builder::iamRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, IAM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceARN;
    private final String iamRoleARN;

    private ConnectAction(BuilderImpl builder) {
        this.instanceARN = builder.instanceARN;
        this.iamRoleARN = builder.iamRoleARN;
    }

    public final String instanceARN() {
        return this.instanceARN;
    }

    public final String iamRoleARN() {
        return this.iamRoleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectAction)) {
            return false;
        }
        ConnectAction other = (ConnectAction)obj;
        return Objects.equals(this.instanceARN(), other.instanceARN()) && Objects.equals(this.iamRoleARN(), other.iamRoleARN());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectAction").add("InstanceARN", (Object)this.instanceARN()).add("IAMRoleARN", (Object)this.iamRoleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceARN": {
                return Optional.ofNullable(clazz.cast(this.instanceARN()));
            }
            case "IAMRoleARN": {
                return Optional.ofNullable(clazz.cast(this.iamRoleARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceARN", INSTANCE_ARN_FIELD);
        map.put("IAMRoleARN", IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectAction, T> g) {
        return obj -> g.apply((ConnectAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceARN;
        private String iamRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectAction model) {
            this.instanceARN(model.instanceARN);
            this.iamRoleARN(model.iamRoleARN);
        }

        public final String getInstanceARN() {
            return this.instanceARN;
        }

        public final void setInstanceARN(String instanceARN) {
            this.instanceARN = instanceARN;
        }

        @Override
        public final Builder instanceARN(String instanceARN) {
            this.instanceARN = instanceARN;
            return this;
        }

        public final String getIamRoleARN() {
            return this.iamRoleARN;
        }

        public final void setIamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
        }

        @Override
        public final Builder iamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
            return this;
        }

        public ConnectAction build() {
            return new ConnectAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectAction> {
        public Builder instanceARN(String var1);

        public Builder iamRoleARN(String var1);
    }
}

