/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest;
import software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse;

public class ListCustomVerificationEmailTemplatesIterable
implements SdkIterable<ListCustomVerificationEmailTemplatesResponse> {
    private final SesClient client;
    private final ListCustomVerificationEmailTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomVerificationEmailTemplatesIterable(SesClient client, ListCustomVerificationEmailTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCustomVerificationEmailTemplatesResponseFetcher();
    }

    public Iterator<ListCustomVerificationEmailTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCustomVerificationEmailTemplatesResponseFetcher
    implements SyncPageFetcher<ListCustomVerificationEmailTemplatesResponse> {
        private ListCustomVerificationEmailTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomVerificationEmailTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomVerificationEmailTemplatesResponse nextPage(ListCustomVerificationEmailTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCustomVerificationEmailTemplatesIterable.this.client.listCustomVerificationEmailTemplates(ListCustomVerificationEmailTemplatesIterable.this.firstRequest);
            }
            return ListCustomVerificationEmailTemplatesIterable.this.client.listCustomVerificationEmailTemplates((ListCustomVerificationEmailTemplatesRequest)((Object)ListCustomVerificationEmailTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

