/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.services.ses.model.VerificationTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyDomainDkimResponse
extends SesResponse
implements ToCopyableBuilder<Builder, VerifyDomainDkimResponse> {
    private static final SdkField<List<String>> DKIM_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DkimTokens").getter(VerifyDomainDkimResponse.getter(VerifyDomainDkimResponse::dkimTokens)).setter(VerifyDomainDkimResponse.setter(Builder::dkimTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DKIM_TOKENS_FIELD));
    private final List<String> dkimTokens;

    private VerifyDomainDkimResponse(BuilderImpl builder) {
        super(builder);
        this.dkimTokens = builder.dkimTokens;
    }

    public final boolean hasDkimTokens() {
        return this.dkimTokens != null && !(this.dkimTokens instanceof SdkAutoConstructList);
    }

    public final List<String> dkimTokens() {
        return this.dkimTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDkimTokens() ? this.dkimTokens() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainDkimResponse)) {
            return false;
        }
        VerifyDomainDkimResponse other = (VerifyDomainDkimResponse)((Object)obj);
        return this.hasDkimTokens() == other.hasDkimTokens() && Objects.equals(this.dkimTokens(), other.dkimTokens());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyDomainDkimResponse").add("DkimTokens", this.hasDkimTokens() ? this.dkimTokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DkimTokens": {
                return Optional.ofNullable(clazz.cast(this.dkimTokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyDomainDkimResponse, T> g) {
        return obj -> g.apply((VerifyDomainDkimResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private List<String> dkimTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainDkimResponse model) {
            super(model);
            this.dkimTokens(model.dkimTokens);
        }

        public final Collection<String> getDkimTokens() {
            if (this.dkimTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dkimTokens;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        @Override
        @Transient
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dkimTokens(String ... dkimTokens) {
            this.dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        @Override
        public VerifyDomainDkimResponse build() {
            return new VerifyDomainDkimResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyDomainDkimResponse> {
        public Builder dkimTokens(Collection<String> var1);

        public Builder dkimTokens(String ... var1);
    }
}

