/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a TXT record that you must publish to the DNS server of your domain to complete domain verification with
 * Amazon SES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyDomainIdentityResponse extends SesResponse implements
        ToCopyableBuilder<VerifyDomainIdentityResponse.Builder, VerifyDomainIdentityResponse> {
    private static final SdkField<String> VERIFICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationToken").getter(getter(VerifyDomainIdentityResponse::verificationToken))
            .setter(setter(Builder::verificationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFICATION_TOKEN_FIELD));

    private final String verificationToken;

    private VerifyDomainIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.verificationToken = builder.verificationToken;
    }

    /**
     * <p>
     * A TXT record that you must place in the DNS settings of the domain to complete domain verification with Amazon
     * SES.
     * </p>
     * <p>
     * As Amazon SES searches for the TXT record, the domain's verification status is "Pending". When Amazon SES detects
     * the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record
     * within 72 hours, the domain's verification status changes to "Failed." In that case, if you still want to verify
     * the domain, you must restart the verification process from the beginning.
     * </p>
     * 
     * @return A TXT record that you must place in the DNS settings of the domain to complete domain verification with
     *         Amazon SES.</p>
     *         <p>
     *         As Amazon SES searches for the TXT record, the domain's verification status is "Pending". When Amazon SES
     *         detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to
     *         detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, if
     *         you still want to verify the domain, you must restart the verification process from the beginning.
     */
    public final String verificationToken() {
        return verificationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verificationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainIdentityResponse)) {
            return false;
        }
        VerifyDomainIdentityResponse other = (VerifyDomainIdentityResponse) obj;
        return Objects.equals(verificationToken(), other.verificationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyDomainIdentityResponse").add("VerificationToken", verificationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerificationToken":
            return Optional.ofNullable(clazz.cast(verificationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyDomainIdentityResponse, T> g) {
        return obj -> g.apply((VerifyDomainIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, VerifyDomainIdentityResponse> {
        /**
         * <p>
         * A TXT record that you must place in the DNS settings of the domain to complete domain verification with
         * Amazon SES.
         * </p>
         * <p>
         * As Amazon SES searches for the TXT record, the domain's verification status is "Pending". When Amazon SES
         * detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect
         * the record within 72 hours, the domain's verification status changes to "Failed." In that case, if you still
         * want to verify the domain, you must restart the verification process from the beginning.
         * </p>
         * 
         * @param verificationToken
         *        A TXT record that you must place in the DNS settings of the domain to complete domain verification
         *        with Amazon SES.</p>
         *        <p>
         *        As Amazon SES searches for the TXT record, the domain's verification status is "Pending". When Amazon
         *        SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable
         *        to detect the record within 72 hours, the domain's verification status changes to "Failed." In that
         *        case, if you still want to verify the domain, you must restart the verification process from the
         *        beginning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationToken(String verificationToken);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private String verificationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainIdentityResponse model) {
            super(model);
            verificationToken(model.verificationToken);
        }

        public final String getVerificationToken() {
            return verificationToken;
        }

        @Override
        public final Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        public final void setVerificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
        }

        @Override
        public VerifyDomainIdentityResponse build() {
            return new VerifyDomainIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
