/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ses.model.IdentityMailFromDomainAttributes;
import software.amazon.awssdk.services.ses.model.MailFromDomainAttributesCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityMailFromDomainAttributesResponse
extends SesResponse
implements ToCopyableBuilder<Builder, GetIdentityMailFromDomainAttributesResponse> {
    private static final SdkField<Map<String, IdentityMailFromDomainAttributes>> MAIL_FROM_DOMAIN_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetIdentityMailFromDomainAttributesResponse.getter(GetIdentityMailFromDomainAttributesResponse::mailFromDomainAttributes)).setter(GetIdentityMailFromDomainAttributesResponse.setter(Builder::mailFromDomainAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomainAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityMailFromDomainAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_FROM_DOMAIN_ATTRIBUTES_FIELD));
    private final Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes;

    private GetIdentityMailFromDomainAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.mailFromDomainAttributes = builder.mailFromDomainAttributes;
    }

    public boolean hasMailFromDomainAttributes() {
        return this.mailFromDomainAttributes != null && !(this.mailFromDomainAttributes instanceof SdkAutoConstructMap);
    }

    public Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes() {
        return this.mailFromDomainAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomainAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityMailFromDomainAttributesResponse)) {
            return false;
        }
        GetIdentityMailFromDomainAttributesResponse other = (GetIdentityMailFromDomainAttributesResponse)((Object)obj);
        return Objects.equals(this.mailFromDomainAttributes(), other.mailFromDomainAttributes());
    }

    public String toString() {
        return ToString.builder((String)"GetIdentityMailFromDomainAttributesResponse").add("MailFromDomainAttributes", this.mailFromDomainAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MailFromDomainAttributes": {
                return Optional.ofNullable(clazz.cast(this.mailFromDomainAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityMailFromDomainAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityMailFromDomainAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityMailFromDomainAttributesResponse model) {
            super(model);
            this.mailFromDomainAttributes(model.mailFromDomainAttributes);
        }

        public final Map<String, IdentityMailFromDomainAttributes.Builder> getMailFromDomainAttributes() {
            return this.mailFromDomainAttributes != null ? CollectionUtils.mapValues(this.mailFromDomainAttributes, IdentityMailFromDomainAttributes::toBuilder) : null;
        }

        @Override
        public final Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copy(mailFromDomainAttributes);
            return this;
        }

        public final void setMailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes.BuilderImpl> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copyFromBuilder(mailFromDomainAttributes);
        }

        @Override
        public GetIdentityMailFromDomainAttributesResponse build() {
            return new GetIdentityMailFromDomainAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityMailFromDomainAttributesResponse> {
        public Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> var1);
    }
}

