/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.RecipientDsnFields;
import software.amazon.awssdk.services.ses.transform.ExtensionFieldUnmarshaller;

public class RecipientDsnFieldsUnmarshaller
implements Unmarshaller<RecipientDsnFields, StaxUnmarshallerContext> {
    private static final RecipientDsnFieldsUnmarshaller INSTANCE = new RecipientDsnFieldsUnmarshaller();

    public RecipientDsnFields unmarshall(StaxUnmarshallerContext context) throws Exception {
        RecipientDsnFields.Builder recipientDsnFields;
        block11: {
            recipientDsnFields = RecipientDsnFields.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ExtensionField> extensionFields = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    recipientDsnFields.extensionFields(extensionFields);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("FinalRecipient", targetDepth)) {
                        recipientDsnFields.finalRecipient(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Action", targetDepth)) {
                        recipientDsnFields.action(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RemoteMta", targetDepth)) {
                        recipientDsnFields.remoteMta(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        recipientDsnFields.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DiagnosticCode", targetDepth)) {
                        recipientDsnFields.diagnosticCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LastAttemptDate", targetDepth)) {
                        recipientDsnFields.lastAttemptDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ExtensionFields", targetDepth)) {
                        extensionFields = new ArrayList<ExtensionField>();
                        continue;
                    }
                    if (!context.testExpression("ExtensionFields/member", targetDepth)) continue;
                    extensionFields.add(ExtensionFieldUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            recipientDsnFields.extensionFields(extensionFields);
        }
        return (RecipientDsnFields)recipientDsnFields.build();
    }

    public static RecipientDsnFieldsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

