/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest;

public class GetIdentityPoliciesRequestMarshaller
implements Marshaller<Request<GetIdentityPoliciesRequest>, GetIdentityPoliciesRequest> {
    public Request<GetIdentityPoliciesRequest> marshall(GetIdentityPoliciesRequest getIdentityPoliciesRequest) {
        List<String> policyNamesList;
        if (getIdentityPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getIdentityPoliciesRequest, "SESClient");
        request.addParameter("Action", "GetIdentityPolicies");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityPoliciesRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)getIdentityPoliciesRequest.identity()));
        }
        if ((policyNamesList = getIdentityPoliciesRequest.policyNames()) != null) {
            if (!policyNamesList.isEmpty()) {
                int policyNamesListIndex = 1;
                for (String policyNamesListValue : policyNamesList) {
                    if (policyNamesListValue != null) {
                        request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString((String)policyNamesListValue));
                    }
                    ++policyNamesListIndex;
                }
            } else {
                request.addParameter("PolicyNames", "");
            }
        }
        return request;
    }
}

