/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloneReceiptRuleSetRequest
extends SESRequest
implements ToCopyableBuilder<Builder, CloneReceiptRuleSetRequest> {
    private final String ruleSetName;
    private final String originalRuleSetName;

    private CloneReceiptRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.originalRuleSetName = builder.originalRuleSetName;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String originalRuleSetName() {
        return this.originalRuleSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalRuleSetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloneReceiptRuleSetRequest)) {
            return false;
        }
        CloneReceiptRuleSetRequest other = (CloneReceiptRuleSetRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.originalRuleSetName(), other.originalRuleSetName());
    }

    public String toString() {
        return ToString.builder((String)"CloneReceiptRuleSetRequest").add("RuleSetName", (Object)this.ruleSetName()).add("OriginalRuleSetName", (Object)this.originalRuleSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.of(clazz.cast(this.ruleSetName()));
            }
            case "OriginalRuleSetName": {
                return Optional.of(clazz.cast(this.originalRuleSetName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String originalRuleSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloneReceiptRuleSetRequest model) {
            this.ruleSetName(model.ruleSetName);
            this.originalRuleSetName(model.originalRuleSetName);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getOriginalRuleSetName() {
            return this.originalRuleSetName;
        }

        @Override
        public final Builder originalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
            return this;
        }

        public final void setOriginalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CloneReceiptRuleSetRequest build() {
            return new CloneReceiptRuleSetRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, CloneReceiptRuleSetRequest> {
        public Builder ruleSetName(String var1);

        public Builder originalRuleSetName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

