/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.BulkEmailDestination;
import software.amazon.awssdk.services.ses.model.BulkEmailDestinationListCopier;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendBulkTemplatedEmailRequest
extends SESRequest
implements ToCopyableBuilder<Builder, SendBulkTemplatedEmailRequest> {
    private final String source;
    private final String sourceArn;
    private final List<String> replyToAddresses;
    private final String returnPath;
    private final String returnPathArn;
    private final String configurationSetName;
    private final List<MessageTag> defaultTags;
    private final String template;
    private final String templateArn;
    private final String defaultTemplateData;
    private final List<BulkEmailDestination> destinations;

    private SendBulkTemplatedEmailRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.sourceArn = builder.sourceArn;
        this.replyToAddresses = builder.replyToAddresses;
        this.returnPath = builder.returnPath;
        this.returnPathArn = builder.returnPathArn;
        this.configurationSetName = builder.configurationSetName;
        this.defaultTags = builder.defaultTags;
        this.template = builder.template;
        this.templateArn = builder.templateArn;
        this.defaultTemplateData = builder.defaultTemplateData;
        this.destinations = builder.destinations;
    }

    public String source() {
        return this.source;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public String returnPath() {
        return this.returnPath;
    }

    public String returnPathArn() {
        return this.returnPathArn;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public List<MessageTag> defaultTags() {
        return this.defaultTags;
    }

    public String template() {
        return this.template;
    }

    public String templateArn() {
        return this.templateArn;
    }

    public String defaultTemplateData() {
        return this.defaultTemplateData;
    }

    public List<BulkEmailDestination> destinations() {
        return this.destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replyToAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPathArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkTemplatedEmailRequest)) {
            return false;
        }
        SendBulkTemplatedEmailRequest other = (SendBulkTemplatedEmailRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.replyToAddresses(), other.replyToAddresses()) && Objects.equals(this.returnPath(), other.returnPath()) && Objects.equals(this.returnPathArn(), other.returnPathArn()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && Objects.equals(this.defaultTags(), other.defaultTags()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.defaultTemplateData(), other.defaultTemplateData()) && Objects.equals(this.destinations(), other.destinations());
    }

    public String toString() {
        return ToString.builder((String)"SendBulkTemplatedEmailRequest").add("Source", (Object)this.source()).add("SourceArn", (Object)this.sourceArn()).add("ReplyToAddresses", this.replyToAddresses()).add("ReturnPath", (Object)this.returnPath()).add("ReturnPathArn", (Object)this.returnPathArn()).add("ConfigurationSetName", (Object)this.configurationSetName()).add("DefaultTags", this.defaultTags()).add("Template", (Object)this.template()).add("TemplateArn", (Object)this.templateArn()).add("DefaultTemplateData", (Object)this.defaultTemplateData()).add("Destinations", this.destinations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "SourceArn": {
                return Optional.of(clazz.cast(this.sourceArn()));
            }
            case "ReplyToAddresses": {
                return Optional.of(clazz.cast(this.replyToAddresses()));
            }
            case "ReturnPath": {
                return Optional.of(clazz.cast(this.returnPath()));
            }
            case "ReturnPathArn": {
                return Optional.of(clazz.cast(this.returnPathArn()));
            }
            case "ConfigurationSetName": {
                return Optional.of(clazz.cast(this.configurationSetName()));
            }
            case "DefaultTags": {
                return Optional.of(clazz.cast(this.defaultTags()));
            }
            case "Template": {
                return Optional.of(clazz.cast(this.template()));
            }
            case "TemplateArn": {
                return Optional.of(clazz.cast(this.templateArn()));
            }
            case "DefaultTemplateData": {
                return Optional.of(clazz.cast(this.defaultTemplateData()));
            }
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String source;
        private String sourceArn;
        private List<String> replyToAddresses;
        private String returnPath;
        private String returnPathArn;
        private String configurationSetName;
        private List<MessageTag> defaultTags;
        private String template;
        private String templateArn;
        private String defaultTemplateData;
        private List<BulkEmailDestination> destinations;

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkTemplatedEmailRequest model) {
            this.source(model.source);
            this.sourceArn(model.sourceArn);
            this.replyToAddresses(model.replyToAddresses);
            this.returnPath(model.returnPath);
            this.returnPathArn(model.returnPathArn);
            this.configurationSetName(model.configurationSetName);
            this.defaultTags(model.defaultTags);
            this.template(model.template);
            this.templateArn(model.templateArn);
            this.defaultTemplateData(model.defaultTemplateData);
            this.destinations(model.destinations);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final Collection<String> getReplyToAddresses() {
            return this.replyToAddresses;
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            this.replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
        }

        public final String getReturnPath() {
            return this.returnPath;
        }

        @Override
        public final Builder returnPath(String returnPath) {
            this.returnPath = returnPath;
            return this;
        }

        public final void setReturnPath(String returnPath) {
            this.returnPath = returnPath;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Collection<MessageTag.Builder> getDefaultTags() {
            return this.defaultTags != null ? (Collection)this.defaultTags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder defaultTags(Collection<MessageTag> defaultTags) {
            this.defaultTags = MessageTagListCopier.copy(defaultTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultTags(MessageTag ... defaultTags) {
            this.defaultTags(Arrays.asList(defaultTags));
            return this;
        }

        public final void setDefaultTags(Collection<MessageTag.BuilderImpl> defaultTags) {
            this.defaultTags = MessageTagListCopier.copyFromBuilder(defaultTags);
        }

        public final String getTemplate() {
            return this.template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        public final String getDefaultTemplateData() {
            return this.defaultTemplateData;
        }

        @Override
        public final Builder defaultTemplateData(String defaultTemplateData) {
            this.defaultTemplateData = defaultTemplateData;
            return this;
        }

        public final void setDefaultTemplateData(String defaultTemplateData) {
            this.defaultTemplateData = defaultTemplateData;
        }

        public final Collection<BulkEmailDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(BulkEmailDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<BulkEmailDestination> destinations) {
            this.destinations = BulkEmailDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(BulkEmailDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final void setDestinations(Collection<BulkEmailDestination.BuilderImpl> destinations) {
            this.destinations = BulkEmailDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendBulkTemplatedEmailRequest build() {
            return new SendBulkTemplatedEmailRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, SendBulkTemplatedEmailRequest> {
        public Builder source(String var1);

        public Builder sourceArn(String var1);

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder returnPath(String var1);

        public Builder returnPathArn(String var1);

        public Builder configurationSetName(String var1);

        public Builder defaultTags(Collection<MessageTag> var1);

        public Builder defaultTags(MessageTag ... var1);

        public Builder template(String var1);

        public Builder templateArn(String var1);

        public Builder defaultTemplateData(String var1);

        public Builder destinations(Collection<BulkEmailDestination> var1);

        public Builder destinations(BulkEmailDestination ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

