/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;

public class GetIdentityVerificationAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityVerificationAttributesRequest>, GetIdentityVerificationAttributesRequest> {
    public Request<GetIdentityVerificationAttributesRequest> marshall(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        if (getIdentityVerificationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getIdentityVerificationAttributesRequest, "SESClient");
        request.addParameter("Action", "GetIdentityVerificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> identitiesList = getIdentityVerificationAttributesRequest.identities();
        if (identitiesList != null) {
            if (!identitiesList.isEmpty()) {
                int identitiesListIndex = 1;
                for (String identitiesListValue : identitiesList) {
                    if (identitiesListValue != null) {
                        request.addParameter("Identities.member." + identitiesListIndex, StringUtils.fromString((String)identitiesListValue));
                    }
                    ++identitiesListIndex;
                }
            } else {
                request.addParameter("Identities", "");
            }
        }
        return request;
    }
}

