/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata;
import software.amazon.awssdk.services.ses.model.ReceiptRuleSetsListsCopier;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListReceiptRuleSetsResponse
extends SESResponse
implements ToCopyableBuilder<Builder, ListReceiptRuleSetsResponse> {
    private final List<ReceiptRuleSetMetadata> ruleSets;
    private final String nextToken;

    private ListReceiptRuleSetsResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSets = builder.ruleSets;
        this.nextToken = builder.nextToken;
    }

    public List<ReceiptRuleSetMetadata> ruleSets() {
        return this.ruleSets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptRuleSetsResponse)) {
            return false;
        }
        ListReceiptRuleSetsResponse other = (ListReceiptRuleSetsResponse)((Object)obj);
        return Objects.equals(this.ruleSets(), other.ruleSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ruleSets() != null) {
            sb.append("RuleSets: ").append(this.ruleSets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSets": {
                return Optional.of(clazz.cast(this.ruleSets()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private List<ReceiptRuleSetMetadata> ruleSets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptRuleSetsResponse model) {
            this.ruleSets(model.ruleSets);
            this.nextToken(model.nextToken);
        }

        public final Collection<ReceiptRuleSetMetadata.Builder> getRuleSets() {
            return this.ruleSets != null ? (Collection)this.ruleSets.stream().map(ReceiptRuleSetMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ruleSets(Collection<ReceiptRuleSetMetadata> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copy(ruleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(ReceiptRuleSetMetadata ... ruleSets) {
            this.ruleSets(Arrays.asList(ruleSets));
            return this;
        }

        public final void setRuleSets(Collection<ReceiptRuleSetMetadata.BuilderImpl> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copyFromBuilder(ruleSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListReceiptRuleSetsResponse build() {
            return new ListReceiptRuleSetsResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, ListReceiptRuleSetsResponse> {
        public Builder ruleSets(Collection<ReceiptRuleSetMetadata> var1);

        public Builder ruleSets(ReceiptRuleSetMetadata ... var1);

        public Builder nextToken(String var1);
    }
}

