/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KinesisFirehoseDestination
implements ToCopyableBuilder<Builder, KinesisFirehoseDestination> {
    private final String iamRoleARN;
    private final String deliveryStreamARN;

    private KinesisFirehoseDestination(BuilderImpl builder) {
        this.iamRoleARN = builder.iamRoleARN;
        this.deliveryStreamARN = builder.deliveryStreamARN;
    }

    public String iamRoleARN() {
        return this.iamRoleARN;
    }

    public String deliveryStreamARN() {
        return this.deliveryStreamARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestination)) {
            return false;
        }
        KinesisFirehoseDestination other = (KinesisFirehoseDestination)obj;
        return Objects.equals(this.iamRoleARN(), other.iamRoleARN()) && Objects.equals(this.deliveryStreamARN(), other.deliveryStreamARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.iamRoleARN() != null) {
            sb.append("IAMRoleARN: ").append(this.iamRoleARN()).append(",");
        }
        if (this.deliveryStreamARN() != null) {
            sb.append("DeliveryStreamARN: ").append(this.deliveryStreamARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IAMRoleARN": {
                return Optional.of(clazz.cast(this.iamRoleARN()));
            }
            case "DeliveryStreamARN": {
                return Optional.of(clazz.cast(this.deliveryStreamARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String iamRoleARN;
        private String deliveryStreamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestination model) {
            this.iamRoleARN(model.iamRoleARN);
            this.deliveryStreamARN(model.deliveryStreamARN);
        }

        public final String getIAMRoleARN() {
            return this.iamRoleARN;
        }

        @Override
        public final Builder iamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
            return this;
        }

        public final void setIAMRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
        }

        public final String getDeliveryStreamARN() {
            return this.deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        public KinesisFirehoseDestination build() {
            return new KinesisFirehoseDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisFirehoseDestination> {
        public Builder iamRoleARN(String var1);

        public Builder deliveryStreamARN(String var1);
    }
}

