/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.services.ses.model.VerificationAttributesCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityVerificationAttributesResponse
extends SESResponse
implements ToCopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
    private final Map<String, IdentityVerificationAttributes> verificationAttributes;

    private GetIdentityVerificationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.verificationAttributes = builder.verificationAttributes;
    }

    public Map<String, IdentityVerificationAttributes> verificationAttributes() {
        return this.verificationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityVerificationAttributesResponse)) {
            return false;
        }
        GetIdentityVerificationAttributesResponse other = (GetIdentityVerificationAttributesResponse)((Object)obj);
        return Objects.equals(this.verificationAttributes(), other.verificationAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.verificationAttributes() != null) {
            sb.append("VerificationAttributes: ").append(this.verificationAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerificationAttributes": {
                return Optional.of(clazz.cast(this.verificationAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private Map<String, IdentityVerificationAttributes> verificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityVerificationAttributesResponse model) {
            this.verificationAttributes(model.verificationAttributes);
        }

        public final Map<String, IdentityVerificationAttributes.Builder> getVerificationAttributes() {
            return this.verificationAttributes != null ? CollectionUtils.mapValues(this.verificationAttributes, IdentityVerificationAttributes::toBuilder) : null;
        }

        @Override
        public final Builder verificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copy(verificationAttributes);
            return this;
        }

        public final void setVerificationAttributes(Map<String, IdentityVerificationAttributes.BuilderImpl> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copyFromBuilder(verificationAttributes);
        }

        @Override
        public GetIdentityVerificationAttributesResponse build() {
            return new GetIdentityVerificationAttributesResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
        public Builder verificationAttributes(Map<String, IdentityVerificationAttributes> var1);
    }
}

