/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateReceiptRuleRequest
extends SESRequest
implements ToCopyableBuilder<Builder, CreateReceiptRuleRequest> {
    private final String ruleSetName;
    private final String after;
    private final ReceiptRule rule;

    private CreateReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.after = builder.after;
        this.rule = builder.rule;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String after() {
        return this.after;
    }

    public ReceiptRule rule() {
        return this.rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.after());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptRuleRequest)) {
            return false;
        }
        CreateReceiptRuleRequest other = (CreateReceiptRuleRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.after(), other.after()) && Objects.equals(this.rule(), other.rule());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ruleSetName() != null) {
            sb.append("RuleSetName: ").append(this.ruleSetName()).append(",");
        }
        if (this.after() != null) {
            sb.append("After: ").append(this.after()).append(",");
        }
        if (this.rule() != null) {
            sb.append("Rule: ").append(this.rule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.of(clazz.cast(this.ruleSetName()));
            }
            case "After": {
                return Optional.of(clazz.cast(this.after()));
            }
            case "Rule": {
                return Optional.of(clazz.cast(this.rule()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String after;
        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptRuleRequest model) {
            this.ruleSetName(model.ruleSetName);
            this.after(model.after);
            this.rule(model.rule);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getAfter() {
            return this.after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        public final ReceiptRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateReceiptRuleRequest build() {
            return new CreateReceiptRuleRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, CreateReceiptRuleRequest> {
        public Builder ruleSetName(String var1);

        public Builder after(String var1);

        public Builder rule(ReceiptRule var1);

        default public Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return this.rule((ReceiptRule)((ReceiptRule.Builder)ReceiptRule.builder().apply(rule)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

