/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.Template;
import software.amazon.awssdk.services.ses.model.UpdateTemplateRequest;

public class UpdateTemplateRequestMarshaller
implements Marshaller<Request<UpdateTemplateRequest>, UpdateTemplateRequest> {
    public Request<UpdateTemplateRequest> marshall(UpdateTemplateRequest updateTemplateRequest) {
        if (updateTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTemplateRequest, "SESClient");
        request.addParameter("Action", "UpdateTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        Template template = updateTemplateRequest.template();
        if (template != null) {
            if (template.templateName() != null) {
                request.addParameter("Template.TemplateName", StringUtils.fromString((String)template.templateName()));
            }
            if (template.subjectPart() != null) {
                request.addParameter("Template.SubjectPart", StringUtils.fromString((String)template.subjectPart()));
            }
            if (template.textPart() != null) {
                request.addParameter("Template.TextPart", StringUtils.fromString((String)template.textPart()));
            }
            if (template.htmlPart() != null) {
                request.addParameter("Template.HtmlPart", StringUtils.fromString((String)template.htmlPart()));
            }
        }
        return request;
    }
}

