/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest;

public class GetIdentityNotificationAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityNotificationAttributesRequest>, GetIdentityNotificationAttributesRequest> {
    public Request<GetIdentityNotificationAttributesRequest> marshall(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) {
        if (getIdentityNotificationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIdentityNotificationAttributesRequest, "SESClient");
        request.addParameter("Action", "GetIdentityNotificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> identitiesList = getIdentityNotificationAttributesRequest.identities();
        if (identitiesList != null) {
            if (!identitiesList.isEmpty()) {
                int identitiesListIndex = 1;
                for (String identitiesListValue : identitiesList) {
                    if (identitiesListValue != null) {
                        request.addParameter("Identities.member." + identitiesListIndex, StringUtils.fromString((String)identitiesListValue));
                    }
                    ++identitiesListIndex;
                }
            } else {
                request.addParameter("Identities", "");
            }
        }
        return request;
    }
}

