/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.transform.CloudWatchDestinationUnmarshaller;
import software.amazon.awssdk.services.ses.transform.KinesisFirehoseDestinationUnmarshaller;
import software.amazon.awssdk.services.ses.transform.SNSDestinationUnmarshaller;

public class EventDestinationUnmarshaller
implements Unmarshaller<EventDestination, StaxUnmarshallerContext> {
    private static final EventDestinationUnmarshaller INSTANCE = new EventDestinationUnmarshaller();

    public EventDestination unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventDestination.Builder eventDestination;
        block10: {
            eventDestination = EventDestination.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> matchingEventTypes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    eventDestination.matchingEventTypes(matchingEventTypes);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        eventDestination.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Enabled", targetDepth)) {
                        eventDestination.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MatchingEventTypes", targetDepth)) {
                        matchingEventTypes = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("MatchingEventTypes/member", targetDepth)) {
                        matchingEventTypes.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KinesisFirehoseDestination", targetDepth)) {
                        eventDestination.kinesisFirehoseDestination(KinesisFirehoseDestinationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CloudWatchDestination", targetDepth)) {
                        eventDestination.cloudWatchDestination(CloudWatchDestinationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("SNSDestination", targetDepth)) continue;
                    eventDestination.snsDestination(SNSDestinationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            eventDestination.matchingEventTypes(matchingEventTypes);
        }
        return (EventDestination)eventDestination.build();
    }

    public static EventDestinationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

