/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.DeleteIdentityRequest;

public class DeleteIdentityRequestMarshaller
implements Marshaller<Request<DeleteIdentityRequest>, DeleteIdentityRequest> {
    public Request<DeleteIdentityRequest> marshall(DeleteIdentityRequest deleteIdentityRequest) {
        if (deleteIdentityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteIdentityRequest, "SESClient");
        request.addParameter("Action", "DeleteIdentity");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIdentityRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)deleteIdentityRequest.identity()));
        }
        return request;
    }
}

