/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest;

public class DeleteIdentityPolicyRequestMarshaller
implements Marshaller<Request<DeleteIdentityPolicyRequest>, DeleteIdentityPolicyRequest> {
    public Request<DeleteIdentityPolicyRequest> marshall(DeleteIdentityPolicyRequest deleteIdentityPolicyRequest) {
        if (deleteIdentityPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteIdentityPolicyRequest, "SESClient");
        request.addParameter("Action", "DeleteIdentityPolicy");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIdentityPolicyRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)deleteIdentityPolicyRequest.identity()));
        }
        if (deleteIdentityPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)deleteIdentityPolicyRequest.policyName()));
        }
        return request;
    }
}

